/*
 * Decompiled with CFR 0.152.
 */
package jreqtools;

import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jreqtools.AbstractRequester;
import jreqtools.StringChecker;
import jreqtools.StringCheckers;
import jreqtools.gadgets.BackgroundImage;
import jreqtools.gadgets.FontShower;
import jreqtools.gadgets.OkCancelButtons;
import jreqtools.gadgets.Strut;
import jreqtools.gadgets.TextField;
import jreqtools.gadgets.YFramePanel;

public class FontRequester
extends AbstractRequester {
    private Font font = null;
    private boolean fixed = false;
    private int answer = -1;
    private static final String[] fontList = FontRequester.makeFontList();
    private static String[] fixedFontList = null;

    public FontRequester() {
        this("JReqTools: FontRequester", new Font("Monospaced", 0, 12));
    }

    public FontRequester(String string) {
        this(string, new Font("Monospaced", 0, 12));
    }

    public FontRequester(Font font) {
        this("JReqTools: FontRequester", font);
    }

    public FontRequester(String string, Font font) {
        this.font = font;
    }

    protected JDialog createJDialog(JFrame jFrame) {
        return new Dialog(jFrame);
    }

    public Font getFont() {
        return this.font;
    }

    public String getFontAsString() {
        String string = "";
        if (this.font.isBold() && this.font.isItalic()) {
            string = "bi";
        } else if (this.font.isBold()) {
            string = "b";
        } else if (this.font.isItalic()) {
            string = "i";
        }
        return this.font.getName() + "/" + this.font.getSize() + string;
    }

    protected int getReturnValue() {
        return this.answer;
    }

    protected static String[] makeFixedFontList() {
        Object[] objectArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        JButton jButton = new JButton();
        Vector<Object> vector = new Vector<Object>();
        int n = 0;
        while (n < objectArray.length) {
            Font font = new Font(objectArray[n], 0, 12);
            FontMetrics fontMetrics = ((Component)jButton).getFontMetrics(font);
            if (fontMetrics.charWidth('w') == fontMetrics.charWidth('i')) {
                vector.addElement(objectArray[n]);
            }
            ++n;
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    protected static String[] makeFontList() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
    }

    public void setFixedWidthOnly(boolean bl) {
        if (fixedFontList == null) {
            fixedFontList = FontRequester.makeFixedFontList();
        }
        this.fixed = bl;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    private class Dialog
    extends JDialog {
        private JList names = new JList();
        private JList size = new JList();
        private TextField entersize = new TextField("");
        private FontShower fontshower = new FontShower();

        public Dialog(JFrame jFrame) {
            super(jFrame, "JReqTools: FontRequester", true);
            this.size.setListData(new String[]{"6", "8", "10", "12", "14", "16", "18", "20", "24", "36", "48", "72"});
            this.size.setSelectedValue("" + FontRequester.this.font.getSize(), true);
            this.size.setSelectionMode(0);
            this.entersize.setText("" + FontRequester.this.font.getSize());
            this.entersize.setColumns(3);
            this.names.setListData(FontRequester.this.fixed ? fixedFontList : fontList);
            this.names.setSelectionMode(0);
            this.names.setSelectedValue(FontRequester.this.font.getName(), true);
            this.fontshower.setFont(FontRequester.this.font);
            this.size.addListSelectionListener(new ListSelectionListener(this){
                private final /* synthetic */ Dialog this$1;
                {
                    this.this$1 = dialog;
                }

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (listSelectionEvent.getValueIsAdjusting()) {
                        return;
                    }
                    Dialog.access$500(this.this$1).setText((String)Dialog.access$400(this.this$1).getSelectedValue());
                    Dialog.access$700(this.this$1).setFont(Dialog.access$600(this.this$1));
                }
            });
            this.names.addListSelectionListener(new ListSelectionListener(this){
                private final /* synthetic */ Dialog this$1;
                {
                    this.this$1 = dialog;
                }

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (listSelectionEvent.getValueIsAdjusting()) {
                        return;
                    }
                    Dialog.access$700(this.this$1).setFont(Dialog.access$600(this.this$1));
                }
            });
            this.entersize.addActionListener(new ActionListener(this){
                private final /* synthetic */ Dialog this$1;
                {
                    this.this$1 = dialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    Dialog.access$700(this.this$1).setFont(Dialog.access$600(this.this$1));
                    Dialog.access$400(this.this$1).setSelectedValue(Dialog.access$500(this.this$1).getText(), true);
                }
            });
            OkCancelButtons okCancelButtons = new OkCancelButtons(FontRequester.this, new ActionListener(this){
                private final /* synthetic */ Dialog this$1;
                {
                    this.this$1 = dialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    Dialog.access$800(this.this$1);
                }
            }, new ActionListener(this){
                private final /* synthetic */ Dialog this$1;
                {
                    this.this$1 = dialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    Dialog.access$900(this.this$1);
                }
            }, FontRequester.this.listener);
            Box box = Box.createVerticalBox();
            box.add(new JScrollPane(this.size, 22, 30));
            box.add(this.entersize);
            Box box2 = Box.createHorizontalBox();
            box2.add(new JScrollPane(this.names, 22, 30));
            box2.add(new Strut());
            box2.add(box);
            YFramePanel yFramePanel = new YFramePanel();
            yFramePanel.add(box2);
            yFramePanel.add(new Strut());
            yFramePanel.add(this.fontshower);
            yFramePanel.add(new Strut());
            yFramePanel.add(okCancelButtons);
            this.setContentPane(yFramePanel);
            this.getLayeredPane().add((Component)new BackgroundImage(), new Integer(Integer.MIN_VALUE));
            this.pack();
        }

        private void cancel() {
            FontRequester.this.answer = -1;
            ((Component)this).setVisible(false);
        }

        private void checkSize() {
            String string = this.entersize.getText();
            StringChecker stringChecker = StringCheckers.getIntegerChecker();
            if (!stringChecker.accept(this.entersize.getText())) {
                this.getToolkit().beep();
                this.entersize.setText("12");
                return;
            }
            try {
                int n = Integer.parseInt(string);
                if (n < 6) {
                    this.getToolkit().beep();
                    this.entersize.setText("6");
                    return;
                }
                if (n > 200) {
                    this.getToolkit().beep();
                    this.entersize.setText("200");
                    return;
                }
            }
            catch (Exception exception) {
                this.getToolkit().beep();
                this.entersize.setText("12");
                return;
            }
        }

        private Font createFont() {
            this.checkSize();
            return new Font((String)this.names.getSelectedValue(), 0, Math.abs(Integer.parseInt(this.entersize.getText())));
        }

        private String[] getFixedFontList() {
            return null;
        }

        private void ok() {
            FontRequester.this.answer = 0;
            FontRequester.this.font = this.createFont();
            ((Component)this).setVisible(false);
        }

        static /* synthetic */ JList access$400(Dialog dialog) {
            return dialog.size;
        }

        static /* synthetic */ TextField access$500(Dialog dialog) {
            return dialog.entersize;
        }

        static /* synthetic */ Font access$600(Dialog dialog) {
            return dialog.createFont();
        }

        static /* synthetic */ FontShower access$700(Dialog dialog) {
            return dialog.fontshower;
        }

        static /* synthetic */ void access$800(Dialog dialog) {
            dialog.ok();
        }

        static /* synthetic */ void access$900(Dialog dialog) {
            dialog.cancel();
        }
    }
}

