/*
 * Decompiled with CFR 0.152.
 */
package jreqtools;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.UIManager;
import javax.swing.border.Border;
import jreqtools.ByteRequester;
import jreqtools.DoubleRequester;
import jreqtools.FloatRequester;
import jreqtools.IntegerRequester;
import jreqtools.LongRequester;
import jreqtools.PasswordRequester;
import jreqtools.SelectRequester;
import jreqtools.ShortRequester;
import jreqtools.StringRequester;
import jreqtools.TextRequester;
import jreqtools.gadgets.BackgroundImage;
import jreqtools.gadgets.BigBorder;
import jreqtools.gadgets.MessageLines;
import jreqtools.gadgets.Strut;
import jreqtools.gadgets.XIcon;
import jreqtools.gadgets.YFramePanel;

public final class JReqTools {
    private static final ResourceBundle resources = ResourceBundle.getBundle("jreqtools.resources.jreqtools");
    private static final int frameSpace = UIManager.getInt("jreqtools.frameSpace");
    private static final int objectSpace = UIManager.getInt("jreqtools.objectSpace");
    private static final Border border = BorderFactory.createEmptyBorder(frameSpace, frameSpace, frameSpace, frameSpace);
    private static final Hashtable icons = new Hashtable();

    private JReqTools() {
    }

    private static String createStringFromException(Throwable throwable) {
        if (throwable == null) {
            return "";
        }
        try {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            throwable.printStackTrace(printWriter);
            StringBuffer stringBuffer = stringWriter.getBuffer();
            if (stringBuffer == null) {
                return "";
            }
            int n = 0;
            while (n < stringBuffer.length()) {
                if (stringBuffer.charAt(n) == '\t') {
                    stringBuffer.setCharAt(n, ' ');
                    stringBuffer.insert(n, "   ");
                    n += 3;
                }
                ++n;
            }
            return stringBuffer.toString();
        }
        catch (Throwable throwable2) {
            throwable2.printStackTrace(System.err);
            return "";
        }
    }

    public static Action getAboutAction(final JFrame jFrame, final String string) {
        return new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                JReqTools.showAboutMessage(jFrame, string);
            }
        };
    }

    static Border getFrameBorder() {
        return border;
    }

    static int getFrameSpace() {
        return frameSpace;
    }

    public static Icon getIcon(String string) {
        Icon icon = null;
        icon = (Icon)icons.get(string);
        if (icon != null) {
            return icon;
        }
        icon = UIManager.getIcon("jreqtools." + string + "Icon");
        if (icon != null) {
            return icon;
        }
        try {
            int n;
            InputStream inputStream = Class.forName("jreqtools.JReqTools").getResourceAsStream("icons/" + string + ".gif");
            if (inputStream == null) {
                return new XIcon();
            }
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
            byte[] byArray = new byte[1024];
            while ((n = bufferedInputStream.read(byArray)) > 0) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            bufferedInputStream.close();
            byteArrayOutputStream.flush();
            byArray = byteArrayOutputStream.toByteArray();
            icon = new ImageIcon(byArray);
            icons.put(string, icon);
            return icon;
        }
        catch (Exception exception) {
            System.err.println(exception);
            return new XIcon();
        }
    }

    static Insets getObjectInsets(int n, int n2, int n3, int n4) {
        return new Insets(n < 0 ? objectSpace : 0, n2 < 0 ? objectSpace : 0, n3 < 0 ? objectSpace : 0, n4 < 0 ? objectSpace : 0);
    }

    static int getObjectSpace() {
        return objectSpace;
    }

    public static String getResourceString(String string) {
        try {
            return resources.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            JReqTools.showMessage(missingResourceException.getLocalizedMessage() + ":\n\n'" + string + "'");
            return "MISSING RESOURCE: " + string;
        }
    }

    public static String getResourceString(String string, String string2) {
        String string3 = JReqTools.getResourceString(string);
        try {
            string3 = MessageFormat.format(string3, string2);
        }
        catch (Exception exception) {
            JReqTools.showException(exception);
        }
        return string3;
    }

    public static byte requestByte(JFrame jFrame, String string, String string2, byte by) {
        ByteRequester byteRequester = new ByteRequester(string, string2, by);
        byteRequester.request(jFrame);
        return byteRequester.getByte();
    }

    public static double requestDouble(JFrame jFrame, String string, String string2, double d) {
        DoubleRequester doubleRequester = new DoubleRequester(string, string2, d);
        doubleRequester.request(jFrame);
        return doubleRequester.getDouble();
    }

    public static float requestFloat(JFrame jFrame, String string, String string2, float f) {
        FloatRequester floatRequester = new FloatRequester(string, string2, f);
        floatRequester.request(jFrame);
        return floatRequester.getFloat();
    }

    public static int requestInteger(JFrame jFrame, String string, String string2, int n) {
        IntegerRequester integerRequester = new IntegerRequester(string, string2, n);
        integerRequester.request(jFrame);
        return integerRequester.getInteger();
    }

    public static long requestLong(JFrame jFrame, String string, String string2, long l) {
        LongRequester longRequester = new LongRequester(string, string2, l);
        longRequester.request(jFrame);
        return longRequester.getLong();
    }

    public static Object requestObject(JFrame jFrame, String string, String string2, Object[] objectArray) {
        SelectRequester selectRequester = new SelectRequester(string, string2, objectArray);
        selectRequester.request(jFrame);
        return selectRequester.getSelectedValue();
    }

    public static char[] requestPassword(JFrame jFrame, String string, String string2) {
        PasswordRequester passwordRequester = new PasswordRequester(string, string2);
        passwordRequester.request(jFrame);
        return passwordRequester.getPassword();
    }

    public static short requestShort(JFrame jFrame, String string, String string2, short s) {
        ShortRequester shortRequester = new ShortRequester(string, string2, s);
        shortRequester.request(jFrame);
        return shortRequester.getShort();
    }

    public static String requestString(JFrame jFrame, String string, String string2, String string3) {
        StringRequester stringRequester = new StringRequester(string, string2, string3);
        stringRequester.request(jFrame);
        return stringRequester.getString();
    }

    public static String requestText(JFrame jFrame, String string, String string2, String string3) {
        TextRequester textRequester = new TextRequester(string, string2, string3);
        textRequester.request(jFrame);
        return textRequester.getText();
    }

    public static void showAboutMessage(String string) {
        JReqTools.showAboutMessage(null, string);
    }

    public static void showAboutMessage(JFrame jFrame, String string) {
        MessageDialog messageDialog = new MessageDialog((Frame)jFrame, JReqTools.getResourceString("About"), string);
        ((Component)messageDialog).setVisible(true);
    }

    public static void showError(String string) {
        JReqTools.showError(null, string);
    }

    public static void showError(JFrame jFrame, String string) {
        MessageDialog messageDialog = new MessageDialog((Frame)jFrame, JReqTools.getResourceString("Error"), string);
        ((Component)messageDialog).setVisible(true);
    }

    public static void showException(Throwable throwable) {
        JReqTools.showException(null, throwable);
    }

    public static void showException(JFrame jFrame, Throwable throwable) {
        MessageDialog messageDialog = new MessageDialog((Frame)jFrame, JReqTools.getResourceString("Exception"), JReqTools.createStringFromException(throwable));
        ((Component)messageDialog).setVisible(true);
    }

    public static void showMessage(String string) {
        JReqTools.showMessage(null, string);
    }

    public static void showMessage(JFrame jFrame, String string) {
        MessageDialog messageDialog = new MessageDialog((Frame)jFrame, JReqTools.getResourceString("Message"), string);
        ((Component)messageDialog).setVisible(true);
    }

    public static void showNotYetImplemented() {
        JReqTools.showNotYetImplemented(null);
    }

    public static void showNotYetImplemented(JFrame jFrame) {
        MessageDialog messageDialog = new MessageDialog((Frame)jFrame, JReqTools.getResourceString("Sorry"), JReqTools.getResourceString("NotYetImplemented"));
        ((Component)messageDialog).setVisible(true);
    }

    public static boolean showQuestion(String string) {
        return JReqTools.showQuestion(null, string, JReqTools.getResourceString("Yes"), JReqTools.getResourceString("No"));
    }

    public static boolean showQuestion(JFrame jFrame, String string) {
        return JReqTools.showQuestion(jFrame, string, JReqTools.getResourceString("Yes"), JReqTools.getResourceString("No"));
    }

    public static boolean showQuestion(String string, String string2, String string3) {
        return JReqTools.showQuestion(null, string, string2, string3);
    }

    public static boolean showQuestion(JFrame jFrame, String string, String string2, String string3) {
        YesNoDialog yesNoDialog = new YesNoDialog(jFrame, JReqTools.getResourceString("Question"), string, string2, string3);
        yesNoDialog.setDefaultCloseOperation(0);
        yesNoDialog.setVisible(true);
        return yesNoDialog.getAnswer();
    }

    static {
        if (UIManager.get("jreqtools.frameSpace") == null) {
            UIManager.put("jreqtools.frameSpace", new Integer(10));
        }
        if (UIManager.get("jreqtools.objectSpace") == null) {
            UIManager.put("jreqtools.objectSpace", new Integer(5));
        }
    }

    private static class YesNoDialog
    extends JDialog {
        JButton yes = new JButton(JReqTools.getResourceString("Yes"), UIManager.getIcon("jreqtools.okIcon"));
        JButton no = new JButton(JReqTools.getResourceString("No"), UIManager.getIcon("jreqtools.cancelIcon"));
        boolean answer = false;

        public YesNoDialog(JFrame jFrame, String string, String string2, String string3, String string4) {
            super(jFrame, string, true);
            this.yes.setText(string3);
            this.no.setText(string4);
            this.yes.addActionListener(new ActionListener(this){
                private final /* synthetic */ YesNoDialog this$0;
                {
                    this.this$0 = yesNoDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$0.answer = true;
                    this.this$0.setVisible(false);
                }
            });
            this.no.addActionListener(new ActionListener(this){
                private final /* synthetic */ YesNoDialog this$0;
                {
                    this.this$0 = yesNoDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$0.answer = false;
                    this.this$0.setVisible(false);
                }
            });
            Box box = Box.createHorizontalBox();
            box.add(this.yes);
            box.add(Box.createHorizontalGlue());
            box.add(new Strut());
            box.add(Box.createHorizontalGlue());
            box.add(this.no);
            MessageLines messageLines = new MessageLines(string2, 2);
            messageLines.setBorder(new BigBorder());
            messageLines.setOpaque(true);
            YFramePanel yFramePanel = new YFramePanel();
            yFramePanel.add(Box.createVerticalGlue());
            yFramePanel.add(messageLines);
            yFramePanel.add(Box.createVerticalGlue());
            yFramePanel.add(new Strut());
            yFramePanel.add(box);
            Color color = messageLines.getBackground();
            float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
            messageLines.setBackground(new Color(Color.HSBtoRGB(fArray[0], fArray[1], (float)Math.max(0.0, (double)fArray[2] - 0.1))));
            this.setContentPane(yFramePanel);
            this.getLayeredPane().add((Component)new BackgroundImage(), new Integer(Integer.MIN_VALUE));
            this.pack();
            this.setResizable(false);
            Dimension dimension = this.getToolkit().getScreenSize();
            Dimension dimension2 = this.getSize();
            ((Component)this).setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        }

        public boolean getAnswer() {
            return this.answer;
        }

        public void setVisible(boolean bl) {
            if (bl) {
                this.no.requestFocus();
            }
            super.setVisible(bl);
        }
    }

    private static final class MessageDialog
    extends JDialog {
        JButton ok = new JButton(JReqTools.getResourceString("Ok"), UIManager.getIcon("jreqtools.okIcon"));

        public MessageDialog(Frame frame, String string, String string2) {
            super(frame, string, true);
            this.ok.addActionListener(new ActionListener(this){
                private final /* synthetic */ MessageDialog this$0;
                {
                    this.this$0 = messageDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$0.setVisible(false);
                }
            });
            Box box = Box.createHorizontalBox();
            box.add(Box.createHorizontalGlue());
            box.add(this.ok);
            box.add(Box.createHorizontalGlue());
            MessageLines messageLines = new MessageLines(string2, 2);
            messageLines.setBorder(new BigBorder());
            messageLines.setOpaque(true);
            YFramePanel yFramePanel = new YFramePanel();
            yFramePanel.add(Box.createVerticalGlue());
            yFramePanel.add(messageLines);
            yFramePanel.add(Box.createVerticalGlue());
            yFramePanel.add(new Strut());
            yFramePanel.add(box);
            Color color = messageLines.getBackground();
            float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
            messageLines.setBackground(new Color(Color.HSBtoRGB(fArray[0], fArray[1], (float)Math.max(0.0, (double)fArray[2] - 0.1))));
            this.setContentPane(yFramePanel);
            this.getLayeredPane().add((Component)new BackgroundImage(), new Integer(Integer.MIN_VALUE));
            this.pack();
            this.setResizable(false);
            Dimension dimension = this.getToolkit().getScreenSize();
            Dimension dimension2 = this.getSize();
            ((Component)this).setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        }

        public void setVisible(boolean bl) {
            if (bl) {
                this.ok.requestFocus();
            }
            super.setVisible(bl);
        }
    }
}

