/*
 * Decompiled with CFR 0.152.
 */
package jreqtools;

import jreqtools.JReqTools;
import jreqtools.StringChecker;

public class StringCheckers {
    static StringChecker javaIdentifierChecker;
    static StringChecker javaPackageChecker;
    static StringChecker integerChecker;
    static StringChecker longChecker;
    static StringChecker floatChecker;
    static StringChecker doubleChecker;
    static StringChecker byteChecker;
    static StringChecker shortChecker;

    public static StringChecker getByteChecker() {
        if (byteChecker == null) {
            byteChecker = new StringChecker(){

                public boolean accept(String string) {
                    if (string.length() == 0) {
                        return false;
                    }
                    try {
                        Byte.valueOf(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        return false;
                    }
                    return true;
                }

                public String getFailMessage() {
                    return JReqTools.getResourceString("StringCheckers.ByteChecker.FailMessage");
                }
            };
        }
        return byteChecker;
    }

    public static StringChecker getDoubleChecker() {
        if (doubleChecker == null) {
            doubleChecker = new StringChecker(){

                public boolean accept(String string) {
                    if (string.length() == 0) {
                        return false;
                    }
                    try {
                        Double.valueOf(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        return false;
                    }
                    return true;
                }

                public String getFailMessage() {
                    return JReqTools.getResourceString("StringCheckers.DoubleChecker.FailMessage");
                }
            };
        }
        return doubleChecker;
    }

    public static StringChecker getFloatChecker() {
        if (floatChecker == null) {
            floatChecker = new StringChecker(){

                public boolean accept(String string) {
                    if (string.length() == 0) {
                        return false;
                    }
                    try {
                        Float.valueOf(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        return false;
                    }
                    return true;
                }

                public String getFailMessage() {
                    return JReqTools.getResourceString("StringCheckers.FloatChecker.FailMessage");
                }
            };
        }
        return floatChecker;
    }

    public static StringChecker getIntegerChecker() {
        if (integerChecker == null) {
            integerChecker = new StringChecker(){

                public boolean accept(String string) {
                    if (string.length() == 0) {
                        return false;
                    }
                    try {
                        Integer.parseInt(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        return false;
                    }
                    return true;
                }

                public String getFailMessage() {
                    return JReqTools.getResourceString("StringCheckers.IntegerChecker.FailMessage");
                }
            };
        }
        return integerChecker;
    }

    public static StringChecker getJavaIdentifierChecker() {
        if (javaIdentifierChecker == null) {
            javaIdentifierChecker = new StringChecker(){

                public boolean accept(String string) {
                    int n = string.length();
                    if (n == 0) {
                        return false;
                    }
                    if (!Character.isJavaIdentifierStart(string.charAt(0))) {
                        return false;
                    }
                    int n2 = 1;
                    while (n2 < n) {
                        if (!Character.isJavaIdentifierPart(string.charAt(n2))) {
                            return false;
                        }
                        ++n2;
                    }
                    return true;
                }

                public String getFailMessage() {
                    return JReqTools.getResourceString("StringCheckers.JavaIdentifierChecker.FailMessage");
                }
            };
        }
        return javaIdentifierChecker;
    }

    public static StringChecker getJavaPackageChecker() {
        if (javaPackageChecker == null) {
            javaPackageChecker = new StringChecker(){

                public boolean accept(String string) {
                    int n = string.length();
                    if (n == 0) {
                        return false;
                    }
                    if (string.endsWith(".")) {
                        return false;
                    }
                    if (!Character.isJavaIdentifierStart(string.charAt(0))) {
                        return false;
                    }
                    int n2 = 1;
                    while (n2 < n) {
                        char c = string.charAt(n2);
                        if (c != '.' && !Character.isJavaIdentifierPart(string.charAt(n2))) {
                            return false;
                        }
                        ++n2;
                    }
                    return true;
                }

                public String getFailMessage() {
                    return JReqTools.getResourceString("StringCheckers.JavaPackageChecker.FailMessage");
                }
            };
        }
        return javaPackageChecker;
    }

    public static StringChecker getLongChecker() {
        if (longChecker == null) {
            longChecker = new StringChecker(){

                public boolean accept(String string) {
                    if (string.length() == 0) {
                        return false;
                    }
                    try {
                        Long.parseLong(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        return false;
                    }
                    return true;
                }

                public String getFailMessage() {
                    return JReqTools.getResourceString("StringCheckers.LongChecker.FailMessage");
                }
            };
        }
        return longChecker;
    }

    public static StringChecker getShortChecker() {
        if (shortChecker == null) {
            shortChecker = new StringChecker(){

                public boolean accept(String string) {
                    if (string.length() == 0) {
                        return false;
                    }
                    try {
                        Short.valueOf(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        return false;
                    }
                    return true;
                }

                public String getFailMessage() {
                    return JReqTools.getResourceString("StringCheckers.ShortChecker.FailMessage");
                }
            };
        }
        return shortChecker;
    }
}

