/*
 * Decompiled with CFR 0.152.
 */
package swing.addon;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jreqtools.ColorRequester;
import swing.addon.Frame;

public class ColorSelector
extends JButton
implements ActionListener {
    private static final boolean DEBUG = false;
    public Object userData;
    Frame parent;
    Color color;
    ColorRequester colorRequester;
    Vector changeListeners = new Vector();

    public ColorSelector(Frame frame, Color color) {
        super(" ");
        this.parent = frame;
        this.color = color;
        this.setAlignmentX(0.5f);
        this.setAlignmentY(0.5f);
        this.setRequestFocusEnabled(false);
        this.addActionListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.colorRequester == null) {
            this.colorRequester = new ColorRequester(this.color);
            this.colorRequester.setParentComponent(this);
        }
        this.colorRequester.setParentComponent(null);
        if (this.colorRequester.request(this.parent) != 0) {
            return;
        }
        this.color = this.colorRequester.getColor();
        this.repaint();
        Enumeration enumeration = this.changeListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((ChangeListener)enumeration.nextElement()).stateChanged(new ChangeEvent(this));
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        if (this.changeListeners == null) {
            super.addChangeListener(changeListener);
        } else {
            this.changeListeners.addElement(changeListener);
        }
    }

    public Color get() {
        return this.color;
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        Insets insets = this.getBorder().getBorderInsets(this);
        Dimension dimension = this.getSize();
        graphics.setColor(this.color);
        graphics.fillRect(insets.left + 1, insets.top + 1, dimension.width - insets.left - insets.right - 2, dimension.height - insets.top - insets.bottom - 2);
    }

    public void set(Color color) {
        this.color = color;
        this.repaint();
    }
}

