/*
 * Decompiled with CFR 0.152.
 */
package swing.addon;

import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import swing.addon.GUISystem;
import swing.addon.Text;

public class ColorizedText
extends Text {
    private static final boolean DEBUG = false;
    public Object userData;
    Color color;
    String text;
    int colorizeFrom = -1;
    int colorizeTo = -1;

    public ColorizedText(String string, Color color) {
        super(string, 2);
        this.text = string;
        this.color = color;
        this.setBorder(true);
    }

    public void colorize(int n, int n2) {
        if (n2 < n) {
            n2 = n;
        }
        this.colorizeFrom = n;
        this.colorizeTo = n2;
        this.repaint();
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        try {
            if (this.colorizeFrom > -1) {
                int n;
                Insets insets = this.getInsets();
                FontMetrics fontMetrics = ((Component)this).getFontMetrics(this.getFont());
                int n2 = this.getWidth();
                int n3 = this.getHeight();
                int n4 = insets.left + fontMetrics.stringWidth(this.text.substring(0, this.colorizeFrom));
                if (n4 + (n = Math.max(5, fontMetrics.stringWidth(this.text.substring(this.colorizeFrom, this.colorizeTo)))) > n2 - 3) {
                    n = n2 - 3 - n4;
                }
                graphics.setXORMode(this.color);
                graphics.fillRect(n4, insets.top, n, n3 - insets.top - insets.bottom);
            }
        }
        catch (Exception exception) {
            GUISystem.err.println(exception);
        }
    }

    public void setText(String string) {
        this.text = string;
        this.colorizeFrom = -1;
        this.colorizeTo = -1;
        super.setText(string);
    }
}

