/*
 * Decompiled with CFR 0.152.
 */
package swing.addon;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import swing.addon.ImageButton;
import swing.addon.Label;
import swing.addon.MenuItem;
import swing.addon.PopupMenu;
import swing.addon.Prefs;
import swing.addon.TextField;
import swing.addon.Utils;
import swing.addon.util.FileAccess;
import swing.addon.util.Sorter;

public class EditableListview
extends Box
implements MouseListener {
    private static final boolean DEBUG = false;
    public Object userData;
    JList list = new JList();
    TextField textfield = new TextField("");
    ImageButton add = new ImageButton(Prefs.getIcon("plus"));
    ImageButton sub = new ImageButton(Prefs.getIcon("minus"));
    ImageButton up = new ImageButton(Prefs.getIcon("up"));
    ImageButton down = new ImageButton(Prefs.getIcon("down"));
    Vector items = new Vector(10);
    int index = -1;
    PopupMenu menu = null;
    boolean added = false;
    JComponent nextComponent = null;
    Vector listeners = new Vector();
    Vector mouseListeners = new Vector();
    Vector changeListeners = new Vector();
    JScrollPane scrollPane = new JScrollPane(this.list, 22, 30);
    private final String NEW_ITEM = Prefs.getResourceString("EditableListview.NewItem");

    public EditableListview() {
        this(null);
    }

    public EditableListview(String[] stringArray) {
        super(1);
        this.textfield.setAlignmentY(0.0f);
        this.add.setAlignmentY(0.0f);
        this.sub.setAlignmentY(0.0f);
        this.up.setAlignmentY(0.0f);
        this.down.setAlignmentY(0.0f);
        this.list.addMouseListener(this);
        this.textfield.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = EditableListview.this.textfield.getText();
                if (EditableListview.this.getSelectedIndex() == -1) {
                    EditableListview.this.addItem(string);
                } else {
                    EditableListview.this.changeSelectedItem(string);
                }
            }
        });
        this.add.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EditableListview.this.addItem(EditableListview.this.NEW_ITEM);
            }
        });
        this.sub.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EditableListview.this.removeSelectedItem();
            }
        });
        this.up.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EditableListview.this.moveSelectedItemUpwards();
            }
        });
        this.down.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EditableListview.this.moveSelectedItemDownwards();
            }
        });
        Box box = new Box(0);
        box.add(this.textfield);
        box.add(this.add);
        box.add(this.sub);
        box.add(this.up);
        box.add(this.down);
        this.add(this.scrollPane);
        this.add(box);
        this.menu = Utils.createPopupMenu(this.list, "Items");
        MenuItem menuItem = this.menu.add(new MenuItem(Prefs.getResourceString("Sort")));
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EditableListview.this.sortItems();
            }
        });
        menuItem = this.menu.add(new MenuItem(Prefs.getResourceString("Clear")));
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EditableListview.this.removeAllItems();
            }
        });
        if (stringArray != null) {
            this.set(stringArray);
        }
        if (Prefs.getShowToolTips()) {
            this.add.setToolTipText(Prefs.getResourceString("EditableListview.ToolTip1"));
            this.sub.setToolTipText(Prefs.getResourceString("EditableListview.ToolTip2"));
            this.up.setToolTipText(Prefs.getResourceString("EditableListview.ToolTip3"));
            this.down.setToolTipText(Prefs.getResourceString("EditableListview.ToolTip4"));
            this.textfield.setToolTipText(Prefs.getResourceString("EditableListview.ToolTip5"));
        }
    }

    public synchronized MenuItem add(MenuItem menuItem) {
        if (!this.added) {
            this.menu.addSeparator();
            this.added = true;
        }
        this.menu.add(menuItem);
        return menuItem;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeListeners.addElement(changeListener);
    }

    public synchronized void addItem(String string) {
        this.items.addElement(string);
        this.index = string.equals(this.NEW_ITEM) ? this.items.size() - 1 : -1;
        this.updateJList();
        this.sendChangeEvent();
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this.listeners.addElement(listSelectionListener);
    }

    public void addMouseListener(MouseListener mouseListener) {
        this.mouseListeners.addElement(mouseListener);
    }

    public synchronized void changeSelectedItem(String string) {
        int n = this.list.getSelectedIndex();
        if (n == -1) {
            return;
        }
        this.items.setElementAt(string, n);
        this.updateJList();
        this.sendChangeEvent();
    }

    public synchronized boolean contains(String string) {
        return this.items.contains(string);
    }

    public void createPopupMenuFrom(String[] stringArray) {
        this.menu.addSeparator();
        Utils.addMenuItemsFrom(stringArray, Prefs.getResourceString("Add") + " \"", "\"", this.menu, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EditableListview.this.addItem(actionEvent.getActionCommand());
            }
        });
    }

    public void createPopupMenuFromFile(String string) {
        this.menu.addSeparator();
        Utils.addMenuItemsFromFile(string, Prefs.getResourceString("Add") + " \"", "\"", this.menu, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EditableListview.this.addItem(actionEvent.getActionCommand());
            }
        });
    }

    public synchronized String[] get() {
        int n = this.items.size();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = (String)this.items.elementAt(n2);
            ++n2;
        }
        return stringArray;
    }

    public synchronized int getSelectedIndex() {
        return this.list.getSelectedIndex();
    }

    public synchronized String getSelectedItem() {
        int n = this.getSelectedIndex();
        if (n == -1) {
            return null;
        }
        return (String)this.items.elementAt(n);
    }

    public synchronized TextField getTextField() {
        return this.textfield;
    }

    public synchronized int length() {
        return this.items.size();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.setSelectedIndex(this.list.locationToIndex(mouseEvent.getPoint()));
        mouseEvent = new MouseEvent(this, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
        Enumeration enumeration = this.mouseListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((MouseListener)enumeration.nextElement()).mouseClicked(mouseEvent);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        mouseEvent = new MouseEvent(this, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
        Enumeration enumeration = this.mouseListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((MouseListener)enumeration.nextElement()).mouseEntered(mouseEvent);
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        mouseEvent = new MouseEvent(this, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
        Enumeration enumeration = this.mouseListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((MouseListener)enumeration.nextElement()).mouseExited(mouseEvent);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        mouseEvent = new MouseEvent(this, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
        Enumeration enumeration = this.mouseListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((MouseListener)enumeration.nextElement()).mousePressed(mouseEvent);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        mouseEvent = new MouseEvent(this, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
        Enumeration enumeration = this.mouseListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((MouseListener)enumeration.nextElement()).mouseReleased(mouseEvent);
        }
    }

    public synchronized void moveSelectedItemDownwards() {
        int n = this.list.getSelectedIndex();
        if (n == -1 || n == this.items.size() - 1) {
            this.getToolkit().beep();
            return;
        }
        Object e = this.items.elementAt(n);
        this.items.removeElementAt(n);
        this.items.insertElementAt(e, ++n);
        this.index = n;
        this.updateJList();
        this.sendChangeEvent();
    }

    public synchronized void moveSelectedItemUpwards() {
        int n = this.list.getSelectedIndex();
        if (n == -1 || n == 0) {
            this.getToolkit().beep();
            return;
        }
        Object e = this.items.elementAt(n);
        this.items.removeElementAt(n);
        this.items.insertElementAt(e, --n);
        this.index = n;
        this.updateJList();
        this.sendChangeEvent();
    }

    public void readFrom(String string) throws IOException {
        String string2;
        this.removeAllItems();
        FileAccess fileAccess = new FileAccess(string);
        while ((string2 = fileAccess.readLine()) != null) {
            this.addItem(string2);
        }
        fileAccess.close();
    }

    public synchronized void removeAllItems() {
        this.items.setSize(0);
        this.index = -1;
        this.updateJList();
        this.sendChangeEvent();
    }

    public synchronized void removeSelectedItem() {
        int n = this.list.getSelectedIndex();
        if (n == -1) {
            this.getToolkit().beep();
            return;
        }
        String string = (String)this.items.elementAt(n);
        this.items.removeElementAt(n);
        this.index = Math.min(n, this.items.size() - 1);
        this.updateJList();
        this.sendChangeEvent();
    }

    public void saveToFile(String string, String string2) throws IOException {
        File file = new File(string);
        file.mkdirs();
        FileAccess fileAccess = new FileAccess(string + File.separator + string2, 2);
        String[] stringArray = this.get();
        int n = 0;
        while (n < stringArray.length) {
            fileAccess.writeLine(stringArray[n]);
            ++n;
        }
        fileAccess.close();
    }

    private void sendChangeEvent() {
        Enumeration enumeration = this.changeListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((ChangeListener)enumeration.nextElement()).stateChanged(new ChangeEvent(this));
        }
    }

    public synchronized void set(String[] stringArray) {
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        this.items.setSize(0);
        int n = 0;
        while (n < stringArray.length) {
            this.items.addElement(stringArray[n]);
            ++n;
        }
        this.index = stringArray.length == 0 ? -1 : 0;
        this.updateJList();
        this.sendChangeEvent();
    }

    public void setChangeEvent() {
    }

    public void setLabel(String string) {
        this.add((Component)new Label(string), 0);
    }

    public synchronized void setSelectedIndex(int n) {
        this.index = n;
        this.updateJList();
    }

    public synchronized void setSelectedItem(String string) {
        this.index = this.items.indexOf(string);
        this.updateJList();
    }

    public void setToolTipText(String string) {
        this.list.setToolTipText(string);
    }

    private synchronized void sortItems() {
        String[] stringArray = this.get();
        Sorter.sort(stringArray);
        this.set(stringArray);
    }

    private void updateJList() {
        this.list.setListData(this.items);
        this.list.repaint();
        if (this.index != -1) {
            this.list.setSelectedIndex(this.index);
            String string = (String)this.items.elementAt(this.index);
            if (string.equals(this.NEW_ITEM)) {
                string = "";
            }
            this.textfield.setText(string);
        } else {
            this.textfield.setText("");
        }
        this.scrollPane.validate();
        this.textfield.requestFocus();
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        listSelectionEvent = new ListSelectionEvent(this, listSelectionEvent.getFirstIndex(), listSelectionEvent.getLastIndex(), listSelectionEvent.getValueIsAdjusting());
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            ((ListSelectionListener)enumeration.nextElement()).valueChanged(listSelectionEvent);
        }
    }
}

