/*
 * Decompiled with CFR 0.152.
 */
package swing.addon;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.filechooser.FileFilter;
import jreqtools.FileRequester;
import jreqtools.JReqTools;
import swing.addon.ImageButton;
import swing.addon.Prefs;
import swing.addon.TextField;
import swing.addon.Utils;

public class FileString
extends Box {
    private static final boolean DEBUG = false;
    public static final int FILES_AND_DIRECTORIES = 0;
    public static final int DIRECTORIES_ONLY = 1;
    ImageButton button;
    TextField textfield;
    int policy;
    FileRequester fileRequester;
    Vector listeners = new Vector();

    public FileString() {
        this("", 0);
    }

    public FileString(File file) {
        this(file == null ? "" : file.toString(), 0);
    }

    public FileString(String string) {
        this(string == null ? "" : string, 0);
    }

    public FileString(String string, int n) {
        super(0);
        this.policy = n;
        this.fileRequester = new FileRequester();
        this.fileRequester.setTitle(Prefs.getResourceString("FileString.Title"));
        this.fileRequester.setDirectoriesOnly(n == 1);
        this.button = new ImageButton(Prefs.getIcon("openFile"));
        this.button.setRequestFocusEnabled(false);
        this.button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FileString.this.request();
            }
        });
        this.textfield = new TextField(string);
        this.textfield.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FileString.this.textEntered();
            }
        });
        this.add(this.textfield);
        this.add(this.button);
    }

    public FileString(File file, int n) {
        this(file == null ? "" : file.toString(), n);
    }

    public void addActionListener(ActionListener actionListener) {
        this.listeners.addElement(actionListener);
    }

    public void addChoosableFileFilter(FileFilter fileFilter) {
        this.fileRequester.addChoosableFileFilter(fileFilter);
    }

    public void addChoosableFileFilter(FileFilter fileFilter, boolean bl) {
        this.fileRequester.addChoosableFileFilter(fileFilter, bl);
    }

    public File getFile() {
        String string = this.textfield.getText();
        return string.length() == 0 ? null : new File(string);
    }

    public String getText() {
        return this.textfield.getText();
    }

    void request() {
        Object object;
        Serializable serializable;
        String string = this.textfield.getText();
        if (string.length() == 0) {
            string = System.getProperty("user.home");
        }
        File file = new File(string);
        if (this.policy == 1) {
            if (file.isFile()) {
                file = new File(file.getParent());
            }
            if (!file.exists() && JReqTools.showQuestion(Prefs.getResourceString("FileString.CreateDirectory", file.toString()))) {
                file.mkdirs();
            }
            this.fileRequester.setFile(file, "");
        } else {
            serializable = file.isDirectory() ? file : new File(file.getParent() == null ? System.getProperty("user.home") : file.getParent());
            object = file.isDirectory() ? "" : file.getName();
            this.fileRequester.setFile((File)serializable, (String)object);
        }
        if (this.fileRequester.request(Utils.getFrame(this)) == 0) {
            this.textfield.setText(this.fileRequester.getFile().toString());
            serializable = new ActionEvent(this, 0, "");
            object = this.listeners.elements();
            while (object.hasMoreElements()) {
                ((ActionListener)object.nextElement()).actionPerformed((ActionEvent)serializable);
            }
        }
    }

    public void setEditable(boolean bl) {
        this.textfield.setEditable(bl);
    }

    public void setEnabled(boolean bl) {
        this.textfield.setEnabled(bl);
        this.button.setEnabled(bl);
    }

    public void setFile(File file) {
        this.textfield.setText(file.toString());
    }

    public void setFile(String string) {
        this.textfield.setText(string);
    }

    public void setToolTipText(String string) {
        this.textfield.setToolTipText(string);
        this.button.setToolTipText(string);
    }

    void textEntered() {
        ActionEvent actionEvent = new ActionEvent(this, 0, "");
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            ((ActionListener)enumeration.nextElement()).actionPerformed(actionEvent);
        }
    }
}

