/*
 * Decompiled with CFR 0.152.
 */
package swing.addon;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Vector;
import javax.swing.JFrame;
import swing.addon.HelpBrowser;
import swing.addon.HelpFileFrame;
import swing.addon.MenuBar;
import swing.addon.Prefs;
import swing.addon.Utils;

public class Frame
extends JFrame {
    private static final boolean DEBUG = false;
    public Object userData;
    private int busyCounter = 0;
    private static final Vector visibleFrames = new Vector();
    private boolean sizeflag = false;

    public Frame(String string) {
        super(string);
        ((Component)this).setLocation(10, 10);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowDeactivated(WindowEvent windowEvent) {
                Component component = Frame.this.getFocusOwner();
                if (component == null) {
                    return;
                }
                Frame.this.dispatchEvent(new FocusEvent(component, 1005));
            }
        });
    }

    public MenuBar add(MenuBar menuBar) {
        this.setJMenuBar(menuBar);
        return menuBar;
    }

    protected void beep() {
        this.getToolkit().beep();
    }

    public void centerOn(Frame frame) {
        Utils.centerOn(frame, this);
    }

    public static void closeAllVisibleFrames() {
        while (visibleFrames.size() > 0) {
            ((Frame)visibleFrames.elementAt(0)).setVisible(false);
        }
    }

    public void setBusy(boolean bl) {
        if (bl) {
            ++this.busyCounter;
            if (this.busyCounter == 1) {
                Utils.setBusy(this, true);
            }
        } else if (!bl) {
            --this.busyCounter;
            if (this.busyCounter == 0) {
                Utils.setBusy(this, false);
            }
        }
    }

    public static void setDefaultHelpBrowser(HelpBrowser helpBrowser) {
        HelpFileFrame.setDefaultHelpBrowser(helpBrowser);
    }

    public static void setDefaultHelpFileDirectory(String string) {
        HelpFileFrame.setDefaultHelpFileDirectory(string);
    }

    public static void setDefaultHelpFileDirectory(File file) {
        HelpFileFrame.setDefaultHelpFileDirectory(file.getAbsolutePath());
    }

    public void setLocation(Point point) {
        super.setLocation(point.x < 0 ? 0 : point.x, point.y < 0 ? 0 : point.y);
    }

    public void setMenuBar(MenuBar menuBar) {
        super.setJMenuBar(menuBar);
    }

    public void setVisible(boolean bl) {
        if (bl) {
            Prefs.initializer.setVisible(false);
        }
        super.setVisible(bl);
        if (bl) {
            visibleFrames.addElement(this);
        } else {
            visibleFrames.removeElement(this);
        }
    }

    public static void showHelpFile(String string) {
        HelpFileFrame.showHelpFile(string);
    }

    public static void showHelpFile(String string, String string2) {
        HelpFileFrame.showHelpFile(string, string2);
    }

    public static void showHelpText(String string) {
        HelpFileFrame.showHelpText(string);
    }
}

