/*
 * Decompiled with CFR 0.152.
 */
package swing.addon;

import java.awt.Component;
import javax.swing.DefaultListModel;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JScrollPane;
import swing.addon.Prefs;

public final class GUISystem {
    private static final boolean DEBUG = false;
    public Object userData;
    public static MessageWindow out = new MessageWindow("Standard OUT");
    public static MessageWindow err = new MessageWindow("Standard ERROR");
    public static MessageWindow debug = new MessageWindow("Standard DEBUG");

    private GUISystem() {
    }

    static {
        Prefs.add("GUISystem.out", out);
        Prefs.add("GUISystem.err", err);
        Prefs.add("GUISystem.debug", debug);
    }

    public static final class MessageWindow
    extends JFrame {
        JList list;
        DefaultListModel model = new DefaultListModel();

        public MessageWindow(String string) {
            super(string);
            this.list = new JList(this.model);
            this.list.setSelectionMode(0);
            this.getContentPane().add(new JScrollPane(this.list, 22, 30));
            this.pack();
        }

        public void println(String string) {
            if (string == null) {
                string = "";
            }
            this.model.addElement(string.replace('\t', ' '));
            ((Component)this).setVisible(true);
            int n = this.model.getSize() - 1;
            this.list.setSelectedIndex(n);
            this.list.ensureIndexIsVisible(n);
        }

        public void println(Throwable throwable) {
            this.println(throwable.toString());
            throwable.printStackTrace(System.err);
        }

        public void println(boolean bl) {
            this.println("" + bl);
        }

        public void println(int n) {
            this.println("" + n);
        }

        public void println(Object object) {
            this.println(object.toString());
        }
    }
}

