/*
 * Decompiled with CFR 0.152.
 */
package swing.addon;

import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Locale;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import jreqtools.JReqTools;
import swing.addon.HelpBrowser;
import swing.addon.Prefs;
import swing.addon.YFramePanel;
import swing.addon.util.FileAccess;
import swing.addon.util.FileUtils;

class HelpFileFrame
extends JFrame {
    private static final boolean DEBUG = false;
    private static String helpfileDirectory = "";
    private static Hashtable helpfileCache = new Hashtable();
    private static HelpFileFrame helpfileFrame = null;
    private static HelpBrowser helpBrowser = null;
    private JEditorPane text = new JEditorPane();

    public HelpFileFrame() {
        super(Prefs.getResourceString("HelpFileFrame.Title"));
        this.text.setEditable(false);
        this.text.setFont(Prefs.getFixedFont());
        this.text.setContentType("text/html");
        JScrollPane jScrollPane = new JScrollPane(this.text);
        jScrollPane.setPreferredSize(new Dimension(300, 500));
        jScrollPane.setMinimumSize(new Dimension(50, 50));
        jScrollPane.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        YFramePanel yFramePanel = new YFramePanel();
        yFramePanel.add(jScrollPane);
        this.setContentPane(yFramePanel);
        this.pack();
        Prefs.add("swing.addon.Frame.HelpFileFrame", this);
    }

    public static String getFileNotFoundExceptionText(String string, String string2) {
        return Prefs.getResourceString("HelpFileFrame.PageNotFound", string + File.separator + string2 + ".html");
    }

    static final String getHelpFilename(String string) {
        String string2 = Locale.getDefault().getLanguage();
        File file = new File(string + "_" + string2 + ".html");
        if (!file.exists() && !(file = new File(string + ".html")).exists()) {
            return string;
        }
        return file.toString();
    }

    public static void setDefaultHelpBrowser(HelpBrowser helpBrowser) {
        HelpFileFrame.helpBrowser = helpBrowser;
    }

    public static void setDefaultHelpFileDirectory(String string) {
        helpfileDirectory = string;
    }

    public void setText(String string) {
        try {
            this.text.setText(string);
        }
        catch (Throwable throwable) {
            JReqTools.showException(throwable);
        }
        ((Component)this).setVisible(true);
    }

    public static void showHelpFile(String string) {
        HelpFileFrame.showHelpFile(helpfileDirectory, string);
    }

    public static void showHelpFile(String string, String string2) {
        String string3;
        if (helpBrowser != null) {
            String string4 = HelpFileFrame.getHelpFilename(string + File.separator + string2);
            if (FileUtils.doesExist(string4)) {
                helpBrowser.setFilename(string4);
            } else {
                helpBrowser.setText(HelpFileFrame.getFileNotFoundExceptionText(string, string2));
            }
            return;
        }
        if (helpfileFrame == null) {
            helpfileFrame = new HelpFileFrame();
        }
        if ((string3 = (String)helpfileCache.get(string + File.separator + string2)) != null) {
            helpfileFrame.setText(string3);
            return;
        }
        try {
            String string5;
            string3 = "";
            FileAccess fileAccess = new FileAccess(HelpFileFrame.getHelpFilename(string + File.separator + string2));
            while ((string5 = fileAccess.readLine()) != null) {
                string3 = string3 + string5 + "\n";
            }
            helpfileCache.put(string + File.separator + string2, string3);
            helpfileFrame.setText(string3);
        }
        catch (FileNotFoundException fileNotFoundException) {
            helpfileFrame.setText(HelpFileFrame.getFileNotFoundExceptionText(string, string2));
        }
        catch (IOException iOException) {
            helpfileFrame.setText(iOException.toString());
        }
    }

    public static void showHelpText(String string) {
        if (helpBrowser != null) {
            helpBrowser.setText(string);
            return;
        }
        if (helpfileFrame == null) {
            helpfileFrame = new HelpFileFrame();
        }
        helpfileFrame.setText(string);
    }
}

