/*
 * Decompiled with CFR 0.152.
 */
package swing.addon;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class ImageViewer
extends JComponent {
    private static final boolean DEBUG = false;
    public static final String NO_IMAGE = "NoImage";
    Icon icon = null;

    public ImageViewer() {
        this.setBorder(BorderFactory.createEtchedBorder());
    }

    public Dimension getMaximumSize() {
        return new Dimension(200, 200);
    }

    public Dimension getMinimumSize() {
        return new Dimension(200, 200);
    }

    public Dimension getPreferredSize() {
        return new Dimension(200, 200);
    }

    public void paint(Graphics graphics) {
        try {
            Dimension dimension = this.getSize();
            graphics.clearRect(0, 0, dimension.width - 1, dimension.height - 1);
            super.paint(graphics);
            if (this.icon == null) {
                return;
            }
            int n = (dimension.width - this.icon.getIconWidth()) / 2;
            int n2 = (dimension.height - this.icon.getIconHeight()) / 2;
            this.icon.paintIcon(this, graphics, n, n2);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    public void setImage(String string) {
        if (string == NO_IMAGE) {
            this.icon = null;
        } else {
            Image image = this.getToolkit().createImage(string);
            this.icon = new ImageIcon(image);
        }
        this.repaint();
    }

    public void setImage(Image image) {
        this.icon = new ImageIcon(image);
        this.repaint();
    }

    public void setImage(Icon icon) {
        this.icon = icon;
        this.repaint();
    }
}

