/*
 * Decompiled with CFR 0.152.
 */
package swing.addon;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import swing.addon.Prefs;
import swing.addon.Text;

public class KeyStrokeComponent
extends Text {
    private static final boolean DEBUG = false;
    Font font = Prefs.getNormalFont();
    boolean hasFocus = false;
    Border b1 = BorderFactory.createRaisedBevelBorder();
    Border b2 = BorderFactory.createLoweredBevelBorder();
    KeyStroke stroke;
    Vector listeners = new Vector();

    public KeyStrokeComponent() {
        this((KeyStroke)null);
    }

    public KeyStrokeComponent(KeyStroke keyStroke) {
        super("", 0);
        this.stroke = keyStroke;
        this.setText(keyStroke != null ? keyStroke.toString() : "---");
        this.setBorder(this.b1);
        this.setFont(this.font);
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                KeyStrokeComponent.this.requestFocus();
            }
        });
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                KeyStrokeComponent.this.hasFocus = true;
                KeyStrokeComponent.this.setBorder(KeyStrokeComponent.this.b2);
                KeyStrokeComponent.this.repaint();
            }

            public void focusLost(FocusEvent focusEvent) {
                KeyStrokeComponent.this.hasFocus = false;
                KeyStrokeComponent.this.setBorder(KeyStrokeComponent.this.b1);
                KeyStrokeComponent.this.repaint();
            }
        });
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                KeyStrokeComponent.this.stroke = KeyStroke.getKeyStrokeForEvent(keyEvent);
                KeyStrokeComponent.this.setText(KeyStrokeComponent.this.stroke.toString());
                ChangeEvent changeEvent = new ChangeEvent(KeyStrokeComponent.this);
                Enumeration enumeration = KeyStrokeComponent.this.listeners.elements();
                while (enumeration.hasMoreElements()) {
                    ((ChangeListener)enumeration.nextElement()).stateChanged(changeEvent);
                }
            }
        });
    }

    public void addChangeListener(ChangeListener changeListener) {
        if (this.listeners.contains(changeListener)) {
            return;
        }
        this.listeners.addElement(changeListener);
    }

    public KeyStroke getKeyStroke() {
        return this.stroke;
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        return new Dimension(200, this.font.getSize() + 10);
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public void setKeyStroke(KeyStroke keyStroke) {
        this.stroke = keyStroke;
        this.setText(keyStroke != null ? keyStroke.toString() : "---");
    }
}

