/*
 * Decompiled with CFR 0.152.
 */
package swing.addon;

import java.awt.Font;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import swing.addon.PopupMenu;
import swing.addon.Utils;

public class Listview
extends JScrollPane
implements MouseListener,
ListSelectionListener {
    private static final boolean DEBUG = false;
    public Object userData;
    JList list = new JList();
    Vector data = new Vector();
    Model model = new Model();
    Vector listeners = new Vector();
    Vector mouseListeners = new Vector();

    public Listview() {
        this((Object[])null);
    }

    public Listview(Object[] objectArray) {
        super(22, 30);
        if (objectArray != null) {
            int n = 0;
            while (n < objectArray.length) {
                this.data.addElement(objectArray[n]);
                ++n;
            }
        }
        this.list.addListSelectionListener(this);
        this.list.addMouseListener(this);
        this.list.setModel(this.model);
        this.list.setSelectionMode(0);
        this.getViewport().setView(this.list);
    }

    public PopupMenu add(PopupMenu popupMenu) {
        this.list.add(popupMenu);
        this.list.addMouseListener(Utils.createMouseListenerForPopupMenu(this.list, popupMenu));
        return popupMenu;
    }

    public synchronized void addElement(Object object) {
        this.data.addElement(object);
        this.model.fire();
        this.validate();
        if (this.data.size() > 0) {
            this.list.setSelectedIndex(0);
        }
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this.listeners.addElement(listSelectionListener);
    }

    public void addMouseListener(MouseListener mouseListener) {
        this.mouseListeners.addElement(mouseListener);
    }

    public synchronized void clear() {
        this.data.setSize(0);
        this.model.fire();
        this.validate();
    }

    public Enumeration elements() {
        return this.data.elements();
    }

    public synchronized Object[] getElements() {
        int n = this.data.size();
        Object[] objectArray = new Object[n];
        int n2 = 0;
        while (n2 < n) {
            objectArray[n2] = this.data.elementAt(n2);
            ++n2;
        }
        return objectArray;
    }

    public ListModel getModel() {
        return this.list.getModel();
    }

    public synchronized int getSelectedIndex() {
        return this.list.getSelectedIndex();
    }

    public synchronized Object getSelectedValue() {
        return this.list.getSelectedValue();
    }

    public synchronized int length() {
        return this.data.size();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        mouseEvent = new MouseEvent(this, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
        Enumeration enumeration = this.mouseListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((MouseListener)enumeration.nextElement()).mouseClicked(mouseEvent);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        mouseEvent = new MouseEvent(this, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
        Enumeration enumeration = this.mouseListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((MouseListener)enumeration.nextElement()).mouseEntered(mouseEvent);
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        mouseEvent = new MouseEvent(this, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
        Enumeration enumeration = this.mouseListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((MouseListener)enumeration.nextElement()).mouseExited(mouseEvent);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        mouseEvent = new MouseEvent(this, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
        Enumeration enumeration = this.mouseListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((MouseListener)enumeration.nextElement()).mousePressed(mouseEvent);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        mouseEvent = new MouseEvent(this, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
        Enumeration enumeration = this.mouseListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((MouseListener)enumeration.nextElement()).mouseReleased(mouseEvent);
        }
    }

    public synchronized void removeAllElements() {
        this.data.setSize(0);
        this.model.fire();
        this.validate();
    }

    public synchronized boolean removeElement(Object object) {
        boolean bl = this.data.removeElement(object);
        this.model.fire();
        this.validate();
        return bl;
    }

    public void setCellRenderer(ListCellRenderer listCellRenderer) {
        this.list.setCellRenderer(listCellRenderer);
    }

    public synchronized void setElements(Vector vector) {
        this.data.setSize(0);
        if (vector != null) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                this.data.addElement(enumeration.nextElement());
            }
        }
        this.model.fire();
        this.validate();
        if (this.data.size() > 0) {
            this.list.setSelectedIndex(0);
        }
    }

    public synchronized void setElements(Object[] objectArray) {
        Vector<Object> vector = new Vector<Object>(objectArray.length);
        int n = 0;
        while (n < objectArray.length) {
            vector.addElement(objectArray[n]);
            ++n;
        }
        this.setElements(vector);
    }

    public void setFont(Font font) {
        if (this.list != null) {
            this.list.setFont(font);
        }
        super.setFont(font);
    }

    public void setReadOnly(boolean bl) {
    }

    public synchronized void setSelectedIndex(int n) {
        this.list.setSelectedIndex(n);
    }

    public synchronized void setSelectedValue(Object object) {
        this.list.setSelectedValue(object, true);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        listSelectionEvent = new ListSelectionEvent(this, listSelectionEvent.getFirstIndex(), listSelectionEvent.getLastIndex(), listSelectionEvent.getValueIsAdjusting());
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            ((ListSelectionListener)enumeration.nextElement()).valueChanged(listSelectionEvent);
        }
    }

    class Model
    extends AbstractListModel {
        Model() {
        }

        void fire() {
            this.fireContentsChanged(this, 0, Listview.this.data.size() - 1);
        }

        public Object getElementAt(int n) {
            if (n < 0 || n >= Listview.this.data.size()) {
                return null;
            }
            return Listview.this.data.elementAt(n);
        }

        public int getSize() {
            return Listview.this.data.size();
        }
    }
}

