/*
 * Decompiled with CFR 0.152.
 */
package swing.addon;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JWindow;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import jreqtools.AbstractRequester;
import jreqtools.FileRequester;
import jreqtools.FileRequester2;
import jreqtools.FontRequester;
import jreqtools.JReqTools;
import jreqtools.TipOfTheDay;
import swing.addon.Button;
import swing.addon.CheckBox;
import swing.addon.ColorSelector;
import swing.addon.ComboBox;
import swing.addon.Dialog;
import swing.addon.EditableListview;
import swing.addon.FileString;
import swing.addon.Frame;
import swing.addon.GUISystem;
import swing.addon.Label;
import swing.addon.Menu;
import swing.addon.MenuBar;
import swing.addon.MenuItem;
import swing.addon.OkCancelButtons;
import swing.addon.Panel;
import swing.addon.Slider;
import swing.addon.Strut;
import swing.addon.TabbedPane;
import swing.addon.Text;
import swing.addon.TextEditor;
import swing.addon.XIcon;
import swing.addon.YFramePanel;
import swing.addon.event.WindowAdapters;
import swing.addon.util.Sorter;

public class Prefs {
    private static final boolean DEBUG = false;
    private static ResourceBundle resources;
    private static final Hashtable prefs;
    private static Hashtable data;
    private static Hashtable swingprefs;
    private static final Hashtable icons;
    private static final Icon xicon;
    private static String filename;
    private static String appname;
    private static Vector windowsToOpen;
    private static String[] lookAndFeelNames;
    private static String[] lookAndFeelClassNames;
    static Initializer initializer;

    private Prefs() {
    }

    public static final void add(String string, Object object) {
        try {
            prefs.put(string, object);
            if (object instanceof Window) {
                Point point = (Point)data.get(string + ".location");
                Dimension dimension = (Dimension)data.get(string + ".dimension");
                Boolean bl = (Boolean)data.get(string + ".visible");
                if (point != null) {
                    ((Component)((Window)object)).setLocation(point);
                }
                if (dimension != null) {
                    ((Component)((Window)object)).setSize(dimension);
                }
                if (bl != null && !(object instanceof Dialog) && bl.booleanValue() && object != GUISystem.out && object != GUISystem.debug && object != GUISystem.err) {
                    windowsToOpen.addElement(object);
                }
                if (object instanceof TipOfTheDay) {
                    Boolean bl2 = (Boolean)data.get(string + ".showNextTime");
                    Integer n = (Integer)data.get(string + ".tipNumber");
                    if (bl2 != null) {
                        ((TipOfTheDay)object).setShowNextTime(bl2);
                    }
                    if (n != null) {
                        ((TipOfTheDay)object).setTip(n);
                    }
                }
            } else if (object instanceof JTabbedPane) {
                JTabbedPane jTabbedPane;
                Integer n = (Integer)data.get(string + ".selected");
                if (n != null && (jTabbedPane = (JTabbedPane)object).getTabCount() > n) {
                    jTabbedPane.setSelectedIndex(n);
                }
            } else if (object instanceof JSplitPane) {
                Integer n = (Integer)data.get(string + ".location");
                if (n != null) {
                    ((JSplitPane)object).setDividerLocation(n);
                }
            } else if (object instanceof TextEditor) {
                String string2 = (String)data.get(string + ".text");
                if (string2 != null) {
                    ((TextEditor)object).setText(string2);
                }
            } else if (object instanceof JTextField) {
                String string3 = (String)data.get(string + ".text");
                if (string3 != null) {
                    ((JTextField)object).setText(string3);
                }
            } else if (object instanceof FileString) {
                String string4 = (String)data.get(string + ".text");
                if (string4 != null) {
                    ((FileString)object).setFile(string4.equals("NULL") ? null : string4);
                }
                Prefs.add(string + ".FileRequester", ((FileString)object).fileRequester);
            } else if (object instanceof EditableListview) {
                Integer n;
                String[] stringArray = (String[])data.get(string + ".texts");
                if (stringArray != null) {
                    ((EditableListview)object).set(stringArray);
                }
                if ((n = (Integer)data.get(string + ".selected")) != null) {
                    ((EditableListview)object).setSelectedIndex(n);
                }
            } else if (object instanceof JComboBox) {
                Integer n = (Integer)data.get(string + ".which");
                if (n != null) {
                    ((JComboBox)object).setSelectedIndex(n);
                }
            } else if (object instanceof JSlider) {
                Integer n = (Integer)data.get(string + ".value");
                if (n != null) {
                    ((JSlider)object).setValue(n);
                }
            } else if (object instanceof JCheckBox) {
                Boolean bl = (Boolean)data.get(string + ".selected");
                if (bl != null) {
                    ((JCheckBox)object).setSelected(bl);
                }
            } else if (object instanceof JToggleButton) {
                Boolean bl = (Boolean)data.get(string + ".selected");
                if (bl != null) {
                    ((JToggleButton)object).setSelected(bl);
                }
            } else if (object instanceof JInternalFrame) {
                Rectangle rectangle = (Rectangle)data.get(string + ".bounds");
                if (rectangle != null) {
                    ((JInternalFrame)object).setBounds(rectangle);
                }
            } else if (object instanceof Hashtable) {
                Hashtable hashtable = (Hashtable)data.get(string + ".data");
                if (hashtable != null) {
                    ((Hashtable)object).clear();
                    Enumeration enumeration = hashtable.keys();
                    while (enumeration.hasMoreElements()) {
                        Object k = enumeration.nextElement();
                        ((Hashtable)object).put(k, hashtable.get(k));
                    }
                }
            } else if (object instanceof AbstractRequester) {
                File file;
                Dimension dimension;
                Point point = (Point)data.get(string + ".location");
                if (point != null) {
                    ((AbstractRequester)object).setLocation(point);
                }
                if ((dimension = (Dimension)data.get(string + ".dimension")) != null) {
                    ((AbstractRequester)object).setSize(dimension);
                }
                if (object instanceof FileRequester2 && (file = (File)data.get(string + ".file")) != null) {
                    ((FileRequester2)object).setFile(file);
                }
            } else if (object instanceof FileRequester) {
                File file = (File)data.get(string + ".file");
                if (file != null) {
                    ((FileRequester)object).setFile(file);
                }
            } else {
                System.err.println("Prefs.add(): unknown object " + object);
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
        }
        catch (Throwable throwable) {
            System.err.println(throwable);
        }
    }

    public static Border getBorder() {
        int n = Prefs.getObjectSpace();
        return BorderFactory.createEmptyBorder(n, n, n, n);
    }

    public static Color getCaretColor() {
        Color color = (Color)swingprefs.get("CaretColor");
        return color != null ? color : Prefs.getDefaultCaretColor();
    }

    public Border getDefaultBorder() {
        int n = Prefs.getDefaultObjectSpace();
        return BorderFactory.createEmptyBorder(n, n, n, n);
    }

    public static Color getDefaultCaretColor() {
        return new Color(255, 0, 0);
    }

    public static Font getDefaultFixedFont() {
        return new Font("Monospaced", 0, 12);
    }

    public static Border getDefaultFrameBorder() {
        int n = Prefs.getDefaultFrameSpace();
        return BorderFactory.createEmptyBorder(n, n, n, n);
    }

    public static int getDefaultFrameSpace() {
        return 10;
    }

    public static Color getDefaultHighlightColor() {
        return new Color(255, 0, 0);
    }

    public static Color getDefaultHighlightTextColor() {
        return new Color(0, 0, 0);
    }

    public static Font getDefaultLargeFont() {
        return new Font("SansSerif", 0, 18);
    }

    public static String getDefaultLookAndFeel() {
        return "javax.swing.plaf.metal.MetalLookAndFeel";
    }

    public static Font getDefaultNormalFont() {
        return new JButton("Test").getFont();
    }

    public static int getDefaultObjectSpace() {
        return 5;
    }

    public static boolean getDefaultShowToolTips() {
        return true;
    }

    public static Font getDefaultSmallFont() {
        return new Font("SansSerif", 0, 8);
    }

    public static String getDefaultTimeZone() {
        return "GMT";
    }

    public static boolean getDefaultUseIconsInTextButtons() {
        return true;
    }

    public static Font getFixedFont() {
        Font font = (Font)swingprefs.get("FixedFont");
        return font != null ? font : Prefs.getDefaultFixedFont();
    }

    public static Border getFrameBorder() {
        int n = Prefs.getFrameSpace();
        return BorderFactory.createEmptyBorder(n, n, n, n);
    }

    public static int getFrameSpace() {
        Integer n = (Integer)swingprefs.get("FrameSpace");
        return n != null ? n : Prefs.getDefaultFrameSpace();
    }

    public static Color getHighlightColor() {
        Color color = (Color)swingprefs.get("HighlightColor");
        return color != null ? color : Prefs.getDefaultHighlightColor();
    }

    public static Color getHighlightTextColor() {
        Color color = (Color)swingprefs.get("HighlightTextColor");
        return color != null ? color : Prefs.getDefaultHighlightTextColor();
    }

    public static Icon getIcon(String string) {
        try {
            return Prefs.getIcon(Class.forName("swing.addon.Prefs"), string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            JReqTools.showException(classNotFoundException);
            return xicon;
        }
    }

    public static Icon getIcon(Class clazz, String string) {
        Icon icon = null;
        icon = (Icon)icons.get(clazz.getName() + "/" + string);
        if (icon != null) {
            return icon;
        }
        try {
            int n;
            InputStream inputStream = clazz.getResourceAsStream("icons/" + string + ".gif");
            if (inputStream == null) {
                GUISystem.err.println("[Can't load icon '" + string + "']");
                return xicon;
            }
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
            byte[] byArray = new byte[1024];
            while ((n = bufferedInputStream.read(byArray)) > 0) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            bufferedInputStream.close();
            byteArrayOutputStream.flush();
            byArray = byteArrayOutputStream.toByteArray();
            icon = new ImageIcon(byArray);
            icons.put(clazz.getName() + "/" + string, icon);
            return icon;
        }
        catch (Exception exception) {
            System.err.println(exception);
            return xicon;
        }
    }

    public static Font getLargeFont() {
        Font font = (Font)swingprefs.get("LargeFont");
        return font != null ? font : Prefs.getDefaultLargeFont();
    }

    public static Icon getLocalizedIcon(String string) {
        try {
            Locale locale = Locale.getDefault();
            String string2 = locale.getLanguage();
            String string3 = locale.getCountry();
            String string4 = locale.getVariant();
            if (string4.length() > 0) {
                string4 = "_" + string4;
            }
            if (string3.length() > 0) {
                string3 = "_" + string3;
            }
            if (Prefs.isIconAvailable(string + "_" + string2 + string3 + string4)) {
                return Prefs.getIcon(string + "_" + string2 + string3 + string4);
            }
            if (Prefs.isIconAvailable(string + "_" + string2 + string3)) {
                return Prefs.getIcon(string + "_" + string2 + string3);
            }
            if (Prefs.isIconAvailable(string + "_" + string2)) {
                return Prefs.getIcon(string + "_" + string2);
            }
            return Prefs.getIcon(string);
        }
        catch (Exception exception) {
            GUISystem.err.println(exception);
            return Prefs.getIcon(string);
        }
    }

    public static String getLookAndFeel() {
        String string = (String)swingprefs.get("LookAndFeel");
        return string != null ? string : Prefs.getDefaultLookAndFeel();
    }

    public static Cursor getNormalCursor() {
        return (Cursor)swingprefs.get("NormalCursor");
    }

    public static Font getNormalFont() {
        Font font = (Font)swingprefs.get("NormalFont");
        return font != null ? font : Prefs.getDefaultNormalFont();
    }

    public static int getObjectSpace() {
        Integer n = (Integer)swingprefs.get("ObjectSpace");
        return n != null ? n : Prefs.getDefaultObjectSpace();
    }

    public static final Properties getProperties() {
        Properties properties = new Properties();
        ((Hashtable)properties).put("swing.font.normal", Prefs.getNormalFont());
        ((Hashtable)properties).put("swing.font.fixed", Prefs.getFixedFont());
        ((Hashtable)properties).put("swing.font.fixed", Prefs.getSmallFont());
        ((Hashtable)properties).put("swing.font.large", Prefs.getLargeFont());
        ((Hashtable)properties).put("swing.color.highlight", Prefs.getHighlightColor());
        ((Hashtable)properties).put("swing.color.highlighttext", Prefs.getHighlightTextColor());
        ((Hashtable)properties).put("swing.color.caret", Prefs.getCaretColor());
        ((Hashtable)properties).put("swing.space.frame", new Integer(Prefs.getFrameSpace()));
        ((Hashtable)properties).put("swing.space.objects", new Integer(Prefs.getObjectSpace()));
        ((Hashtable)properties).put("swing.show.tooltips", new Boolean(Prefs.getShowToolTips()));
        ((Hashtable)properties).put("swing.look.and.feel", Prefs.getLookAndFeel());
        return properties;
    }

    public static String getResourceString(String string) {
        try {
            return resources.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            JReqTools.showMessage(missingResourceException.getLocalizedMessage() + ":\n\n'" + string + "'");
            return "MISSING RESOURCE: " + string;
        }
    }

    public static String getResourceString(String string, String string2) {
        String string3 = Prefs.getResourceString(string);
        try {
            string3 = MessageFormat.format(string3, string2);
        }
        catch (Exception exception) {
            JReqTools.showException(exception);
        }
        return string3;
    }

    public static String getResourceString(String string, String string2, String string3) {
        String string4 = Prefs.getResourceString(string);
        try {
            string4 = MessageFormat.format(string4, string2, string3);
        }
        catch (Exception exception) {
            JReqTools.showException(exception);
        }
        return string4;
    }

    public static boolean getShowToolTips() {
        Boolean bl = (Boolean)swingprefs.get("ShowToolTips");
        return bl != null ? bl : Prefs.getDefaultShowToolTips();
    }

    public static Font getSmallFont() {
        Font font = (Font)swingprefs.get("SmallFont");
        return font != null ? font : Prefs.getDefaultSmallFont();
    }

    public static String getTimeZone() {
        String string = (String)swingprefs.get("TimeZone");
        return string != null ? string : Prefs.getDefaultTimeZone();
    }

    public static boolean getUseIconsInTextButtons() {
        Boolean bl = (Boolean)swingprefs.get("UseIconsInTextButtons");
        return bl != null ? bl : Prefs.getDefaultUseIconsInTextButtons();
    }

    public static Cursor getWaitCursor() {
        return (Cursor)swingprefs.get("WaitCursor");
    }

    public static final void init(String string) {
        Prefs.init(string, Prefs.getLocalizedIcon("starting"), false, false);
    }

    public static final void init(String string, Icon icon) {
        Prefs.init(string, icon, true);
    }

    public static final void init(String string, Icon icon, boolean bl) {
        Prefs.init(string, icon, bl, true);
    }

    public static final void init(String string, Icon icon, boolean bl, boolean bl2) {
        try {
            resources = ResourceBundle.getBundle("swing.addon.resources.addon");
            appname = string;
            initializer = new Initializer(icon, bl, bl2);
            String string2 = System.getProperty("jedi.runfrom");
            if (string2 == null) {
                string2 = "";
            }
            filename = System.getProperty("user.home") + File.separator + "." + appname + string2;
            ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(filename));
            data = (Hashtable)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (Exception exception) {
            JReqTools.showException(exception);
        }
    }

    public static boolean isIconAvailable(String string) {
        try {
            return Prefs.isIconAvailable(Class.forName("swing.addon.Prefs"), string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public static boolean isIconAvailable(Class clazz, String string) {
        Icon icon = null;
        icon = (Icon)icons.get(clazz.getName() + "/" + string);
        if (icon != null) {
            return true;
        }
        try {
            InputStream inputStream = clazz.getResourceAsStream("icons/" + string + ".gif");
            return inputStream != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isWindowsSystem() {
        String string = System.getProperty("os.name");
        return string != null && string.indexOf("Windows") != -1;
    }

    private static void loadPrefs() {
        String string = System.getProperty("user.home") + File.separator + ".swing.addon.prefs";
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(string));
            swingprefs = (Hashtable)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            swingprefs.put("TimeZone", Prefs.getDefaultTimeZone());
            swingprefs.put("LookAndFeel", Prefs.getDefaultLookAndFeel());
            swingprefs.put("NormalFont", Prefs.getDefaultNormalFont());
            swingprefs.put("SmallFont", Prefs.getDefaultSmallFont());
            swingprefs.put("FixedFont", Prefs.getDefaultFixedFont());
            swingprefs.put("ObjectSpace", new Integer(Prefs.getDefaultObjectSpace()));
            swingprefs.put("FrameSpace", new Integer(Prefs.getDefaultFrameSpace()));
            swingprefs.put("ShowToolTips", new Boolean(Prefs.getDefaultShowToolTips()));
            swingprefs.put("UseIconsInTextButtons", new Boolean(Prefs.getDefaultUseIconsInTextButtons()));
            swingprefs.put("HighlightColor", Prefs.getDefaultHighlightColor());
            swingprefs.put("HighlightTextColor", Prefs.getDefaultHighlightTextColor());
            swingprefs.put("CaretColor", Prefs.getDefaultCaretColor());
        }
        catch (Throwable throwable) {
            JReqTools.showException(throwable);
        }
        swingprefs.put("NormalCursor", new Cursor(0));
        swingprefs.put("WaitCursor", new Cursor(3));
        TimeZone.setDefault(TimeZone.getTimeZone(Prefs.getTimeZone()));
    }

    public static void main(String[] stringArray) {
        Prefs.init("SwingPrefs", Prefs.getIcon("swing.addon.prefs-title"), false, false);
        UIManager.put("jreqtools.okIcon", Prefs.getIcon("ok"));
        UIManager.put("jreqtools.cancelIcon", Prefs.getIcon("cancel"));
        UIManager.put("jreqtools.helpIcon", Prefs.getIcon("help"));
        UIManager.put("jreqtools.frameSpace", new Integer(Prefs.getFrameSpace()));
        UIManager.put("jreqtools.objectSpace", new Integer(Prefs.getObjectSpace()));
        PrefsFrame prefsFrame = new PrefsFrame();
        prefsFrame.setVisible(true);
        Prefs.openWindows();
    }

    public static void openWindows() {
        int n = windowsToOpen.size();
        int n2 = 0;
        while (n2 < n) {
            ((Component)((Window)windowsToOpen.elementAt(n2))).setVisible(true);
            ++n2;
        }
    }

    public static void putProperty(String string, Object object) {
        swingprefs.put(string, object);
    }

    public static final void save() {
        Prefs.snapshot();
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(filename));
            objectOutputStream.writeObject(data);
            objectOutputStream.close();
        }
        catch (Throwable throwable) {
            JReqTools.showException(throwable);
        }
    }

    public static void savePrefs() {
        String string = System.getProperty("user.home") + File.separator + ".swing.addon.prefs";
        Hashtable hashtable = (Hashtable)swingprefs.clone();
        hashtable.remove("WaitCursor");
        hashtable.remove("NormalCursor");
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(string));
            objectOutputStream.writeObject(hashtable);
            objectOutputStream.close();
        }
        catch (Throwable throwable) {
            JReqTools.showException(throwable);
        }
    }

    public static void setInitializerMessage(String string) {
        Prefs.initializer.message.setText(string);
    }

    public static final void snapshot() {
        String string = "";
        Enumeration enumeration = prefs.keys();
        while (enumeration.hasMoreElements()) {
            try {
                Comparable<Boolean> comparable;
                Serializable serializable;
                Object object;
                string = (String)enumeration.nextElement();
                Object v = prefs.get(string);
                if (v instanceof Window) {
                    object = ((Window)v).getLocation();
                    serializable = ((Window)v).getSize();
                    comparable = new Boolean(((Window)v).isVisible());
                    data.put(string + ".location", object);
                    data.put(string + ".dimension", serializable);
                    data.put(string + ".visible", comparable);
                    if (!(v instanceof TipOfTheDay)) continue;
                    Boolean bl = new Boolean(((TipOfTheDay)v).getShowNextTime());
                    Integer n = new Integer(((TipOfTheDay)v).getTip());
                    data.put(string + ".showNextTime", bl);
                    data.put(string + ".tipNumber", n);
                    continue;
                }
                if (v instanceof JTabbedPane) {
                    object = new Integer(((JTabbedPane)v).getSelectedIndex());
                    data.put(string + ".selected", object);
                    continue;
                }
                if (v instanceof JSplitPane) {
                    object = new Integer(((JSplitPane)v).getDividerLocation());
                    data.put(string + ".location", object);
                    continue;
                }
                if (v instanceof TextEditor) {
                    object = ((TextEditor)v).getText();
                    data.put(string + ".text", object);
                    continue;
                }
                if (v instanceof JTextField) {
                    object = ((JTextField)v).getText();
                    data.put(string + ".text", object);
                    continue;
                }
                if (v instanceof FileString) {
                    object = ((FileString)v).getFile();
                    data.put(string + ".text", object == null ? "NULL" : object.toString());
                    continue;
                }
                if (v instanceof EditableListview) {
                    object = ((EditableListview)v).get();
                    data.put(string + ".texts", object);
                    serializable = new Integer(((EditableListview)v).getSelectedIndex());
                    data.put(string + ".selected", serializable);
                    continue;
                }
                if (v instanceof JComboBox) {
                    object = new Integer(((JComboBox)v).getSelectedIndex());
                    data.put(string + ".which", object);
                    continue;
                }
                if (v instanceof JSlider) {
                    object = new Integer(((JSlider)v).getValue());
                    data.put(string + ".value", object);
                    continue;
                }
                if (v instanceof JCheckBox) {
                    object = new Boolean(((JCheckBox)v).isSelected());
                    data.put(string + ".selected", object);
                    continue;
                }
                if (v instanceof JToggleButton) {
                    object = new Boolean(((JToggleButton)v).isSelected());
                    data.put(string + ".selected", object);
                    continue;
                }
                if (v instanceof JInternalFrame) {
                    object = ((JInternalFrame)v).getBounds();
                    data.put(string + ".bounds", object);
                    continue;
                }
                if (v instanceof Hashtable) {
                    data.put(string + ".data", v);
                    continue;
                }
                if (v instanceof AbstractRequester) {
                    object = ((AbstractRequester)v).getLocation();
                    data.put(string + ".location", object);
                    serializable = ((AbstractRequester)v).getSize();
                    data.put(string + ".dimension", serializable);
                    if (!(v instanceof FileRequester2)) continue;
                    comparable = ((FileRequester2)v).getFile();
                    data.put(string + ".file", comparable);
                    continue;
                }
                if (v instanceof FileRequester) {
                    object = ((FileRequester)v).getFile();
                    data.put(string + ".file", object);
                    continue;
                }
                GUISystem.err.println("Prefs.snapshot(): unknown object " + v);
            }
            catch (NullPointerException nullPointerException) {
                System.err.println("NullPointerException while processing " + string);
            }
            catch (Exception exception) {
                System.err.println(exception);
            }
        }
    }

    static {
        int n;
        Object object;
        Class<?> clazz;
        resources = null;
        prefs = new Hashtable(100);
        data = new Hashtable(100);
        swingprefs = new Hashtable(100);
        icons = new Hashtable(20);
        xicon = new XIcon();
        windowsToOpen = new Vector(10, 10);
        GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        try {
            boolean bl = false;
            clazz = Class.forName("swing.addon.plaf.ultimate.UltimateLookAndFeel");
            object = UIManager.getInstalledLookAndFeels();
            n = 0;
            while (n < ((UIManager.LookAndFeelInfo[])object).length) {
                if (object[n].getClassName().equals("swing.addon.plaf.ultimate.UltimateLookAndFeel")) {
                    bl = true;
                }
                ++n;
            }
            if (!bl) {
                UIManager.installLookAndFeel("Ultimate Look & Feel", "swing.addon.plaf.ultimate.UltimateLookAndFeel");
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            boolean bl = false;
            clazz = Class.forName("swing.addon.plaf.threeD.ThreeDLookAndFeel");
            object = UIManager.getInstalledLookAndFeels();
            n = 0;
            while (n < ((UIManager.LookAndFeelInfo[])object).length) {
                if (object[n].getClassName().equals("swing.addon.plaf.threeD.ThreeDLookAndFeel")) {
                    bl = true;
                }
                ++n;
            }
            if (!bl) {
                UIManager.installLookAndFeel("3D Look & Feel", "swing.addon.plaf.threeD.ThreeDLookAndFeel");
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        Prefs.loadPrefs();
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
        lookAndFeelNames = new String[lookAndFeelInfoArray.length];
        lookAndFeelClassNames = new String[lookAndFeelInfoArray.length];
        int n2 = 0;
        while (n2 < lookAndFeelInfoArray.length) {
            Prefs.lookAndFeelNames[n2] = lookAndFeelInfoArray[n2].getName();
            Prefs.lookAndFeelClassNames[n2] = lookAndFeelInfoArray[n2].getClassName();
            ++n2;
        }
        try {
            object = Prefs.getLookAndFeel();
            UIManager.setLookAndFeel((String)object);
        }
        catch (Throwable throwable) {
            JReqTools.showException(throwable);
        }
        object = Prefs.getNormalFont();
        Font font = Prefs.getSmallFont();
        UIManager.put("Button.font", object);
        UIManager.put("CheckBox.font", object);
        UIManager.put("ColorChooser.font", object);
        UIManager.put("ComboBox.font", object);
        UIManager.put("CheckBoxMenuItem.font", object);
        UIManager.put("CheckBoxMenuItem.acceleratorFont", font);
        UIManager.put("EditorPane.font", object);
        UIManager.put("InternalFrame.titleFont", object);
        UIManager.put("Label.font", object);
        UIManager.put("List.font", object);
        UIManager.put("Menu.font", object);
        UIManager.put("Menu.acceleratorFont", font);
        UIManager.put("MenuBar.font", object);
        UIManager.put("MenuItem.font", object);
        UIManager.put("MenuItem.acceleratorFont", font);
        UIManager.put("OptionPane.font", object);
        UIManager.put("Panel.font", object);
        UIManager.put("PasswordField.font", object);
        UIManager.put("PopupMenu.font", object);
        UIManager.put("ProgressBar.font", object);
        UIManager.put("RadioButton.font", object);
        UIManager.put("RadioButtonMenuItem.font", object);
        UIManager.put("RadioButtonMenuItem.acceleratorFont", font);
        UIManager.put("ScrollPane.font", object);
        UIManager.put("TabbedPane.font", object);
        UIManager.put("Table.font", object);
        UIManager.put("TableHeader.font", object);
        UIManager.put("TextArea.font", object);
        UIManager.put("TextField.font", object);
        UIManager.put("TextPane.font", object);
        UIManager.put("TitledBorder.font", object);
        UIManager.put("ToggleButton.font", object);
        UIManager.put("ToolBar.font", object);
        UIManager.put("ToolTip.font", object);
        UIManager.put("Tree.font", object);
        UIManager.put("TextField.caretForeground", Prefs.getCaretColor());
        UIManager.put("PasswordField.caretForeground", Prefs.getCaretColor());
        UIManager.put("TextArea.caretForeground", Prefs.getCaretColor());
        UIManager.put("TextPane.caretForeground", Prefs.getCaretColor());
        UIManager.put("EditorPane.caretForeground", Prefs.getCaretColor());
        UIManager.put("TextField.selectionBackground", Prefs.getHighlightColor());
        UIManager.put("PasswordField.selectionBackground", Prefs.getHighlightColor());
        UIManager.put("TextArea.selectionBackground", Prefs.getHighlightColor());
        UIManager.put("TextPane.selectionBackground", Prefs.getHighlightColor());
        UIManager.put("EditorPane.selectionBackground", Prefs.getHighlightColor());
        UIManager.put("TextField.selectionForeground", Prefs.getHighlightTextColor());
        UIManager.put("PasswordField.selectionForeground", Prefs.getHighlightTextColor());
        UIManager.put("TextAreae.selectionForeground", Prefs.getHighlightTextColor());
        UIManager.put("TextPane.selectionForeground", Prefs.getHighlightTextColor());
        UIManager.put("EditorPane.selectionForeground", Prefs.getHighlightTextColor());
        UIManager.put("JSlider.isFilled", Boolean.TRUE);
        if (Prefs.getUseIconsInTextButtons()) {
            UIManager.put("jreqtools.okIcon", Prefs.getIcon("ok"));
            UIManager.put("jreqtools.cancelIcon", Prefs.getIcon("cancel"));
            UIManager.put("jreqtools.helpIcon", Prefs.getIcon("help"));
        }
        UIManager.put("jreqtools.frameSpace", new Integer(Prefs.getFrameSpace()));
        UIManager.put("jreqtools.objectSpace", new Integer(Prefs.getObjectSpace()));
    }

    static final class SelectArrowIcon
    implements Icon {
        SelectArrowIcon() {
        }

        public int getIconHeight() {
            return this.getIconWidth();
        }

        public int getIconWidth() {
            return 13;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            int n3 = this.getIconWidth();
            if (n3 % 2 == 0) {
                --n3;
            }
            graphics.setColor(Color.black);
            graphics.fillPolygon(new int[]{n + (n3 - 1) / 2, n + 1, n + n3 - 1}, new int[]{n2 + 2, n2 + n3 - 6, n2 + n3 - 6}, 3);
            graphics.fillRect(n + 2, n2 + n3 - 4, n3 - 4, 2);
        }
    }

    static final class PrefsFrame
    extends Frame
    implements ActionListener {
        ColorSelector highlightColor = new ColorSelector(this, Color.red);
        ColorSelector highlightTextColor = new ColorSelector(this, Color.black);
        ColorSelector caretColor = new ColorSelector(this, Color.red);
        FontRequester normalFontRequester = new FontRequester(Prefs.getNormalFont());
        FontRequester fixedFontRequester = new FontRequester(Prefs.getFixedFont());
        FontRequester smallFontRequester = new FontRequester(Prefs.getSmallFont());
        FontRequester largeFontRequester = new FontRequester(Prefs.getLargeFont());
        Button normalfont = new Button(this.normalFontRequester.getFontAsString());
        Button fixedfont = new Button(this.fixedFontRequester.getFontAsString());
        Button smallfont = new Button(this.smallFontRequester.getFontAsString());
        Button largefont = new Button(this.largeFontRequester.getFontAsString());
        Slider objectSpace = new Slider(0, 0, 15, 5);
        Slider frameSpace = new Slider(0, 0, 20, 10);
        CheckBox useIcons = new CheckBox(Prefs.getResourceString("PrefsFrame.CheckBox1"), true);
        ComboBox lookandfeel = new ComboBox(Prefs.access$100());
        ComboBox timezone = new ComboBox(PrefsFrame.getTimeZones());
        Text time = new Text(new Date().toString());
        CheckBox tooltips = new CheckBox(Prefs.getResourceString("PrefsFrame.CheckBox3"));
        OkCancelButtons buttons = new OkCancelButtons();
        MenuBar menubar = new MenuBar();
        Menu program = new Menu(Prefs.getResourceString("PrefsFrame.Menu1"));
        Menu edit = new Menu(Prefs.getResourceString("PrefsFrame.Menu2"));
        MenuItem save = new MenuItem(Prefs.getResourceString("PrefsFrame.Menu1.Item1"));
        MenuItem quit = new MenuItem(Prefs.getResourceString("PrefsFrame.Menu1.Item2"));
        MenuItem savedValues = new MenuItem(Prefs.getResourceString("PrefsFrame.Menu2.Item1"));
        MenuItem defaultValues = new MenuItem(Prefs.getResourceString("PrefsFrame.Menu2.Item2"));

        public PrefsFrame() {
            super(Prefs.getResourceString("PrefsFrame.Title"));
            this.normalFontRequester.setParentComponent(this.normalfont);
            this.fixedFontRequester.setParentComponent(this.fixedfont);
            this.largeFontRequester.setParentComponent(this.largefont);
            this.smallFontRequester.setParentComponent(this.smallfont);
            this.lastSaved();
            this.program.add(this.save);
            this.program.addSeparator();
            this.program.add(this.quit);
            this.edit.add(this.savedValues);
            this.edit.add(this.defaultValues);
            this.menubar.add(this.program);
            this.menubar.add(this.edit);
            this.normalfont.addActionListener(this);
            this.fixedfont.addActionListener(this);
            this.largefont.addActionListener(this);
            this.smallfont.addActionListener(this);
            this.buttons.addActionListener(this);
            this.save.addActionListener(this);
            this.quit.addActionListener(this);
            this.savedValues.addActionListener(this);
            this.defaultValues.addActionListener(this);
            this.lookandfeel.addActionListener(this);
            TabbedPane tabbedPane = new TabbedPane();
            tabbedPane.addTab(Prefs.getResourceString("PrefsFrame.TabbedPane.1"), Prefs.getIcon("prefs-font"), this.createFontPanel());
            tabbedPane.addTab(Prefs.getResourceString("PrefsFrame.TabbedPane.2"), Prefs.getIcon("prefs-time"), this.createTimeZonePanel());
            tabbedPane.addTab(Prefs.getResourceString("PrefsFrame.TabbedPane.3"), Prefs.getIcon("prefs-lookandfeel"), this.createLookAndFeelPanel());
            tabbedPane.addTab(Prefs.getResourceString("PrefsFrame.TabbedPane.4"), Prefs.getIcon("prefs-layout"), this.createLayoutPanel());
            tabbedPane.addTab(Prefs.getResourceString("PrefsFrame.TabbedPane.5"), Prefs.getIcon("prefs-tooltips"), this.createToolTipsPanel());
            tabbedPane.addTab(Prefs.getResourceString("PrefsFrame.TabbedPane.6"), Prefs.getIcon("prefs-colors"), this.createColorsPanel());
            YFramePanel yFramePanel = new YFramePanel();
            yFramePanel.add(tabbedPane);
            yFramePanel.add(new Strut());
            yFramePanel.add(this.buttons);
            this.setContentPane(yFramePanel);
            this.setMenuBar(this.menubar);
            this.addWindowListener(new WindowAdapters.ExitApplicationAdapter());
            this.pack();
            Prefs.add("SwingAddonPrefsFrame", this);
            Prefs.add("SwingAddonPrefsFrame.TabbedPane", tabbedPane);
            Prefs.add("SwingAddonPrefsFrame.FontRequester.normal", this.normalFontRequester);
            Prefs.add("SwingAddonPrefsFrame.FontRequester.fixed", this.fixedFontRequester);
            Prefs.add("SwingAddonPrefsFrame.FontRequester.large", this.largeFontRequester);
            Prefs.add("SwingAddonPrefsFrame.FontRequester.small", this.smallFontRequester);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.normalfont) {
                this.normalFontRequester.request(this);
                this.normalfont.setText(this.normalFontRequester.getFontAsString());
                this.normalfont.setFont(this.normalFontRequester.getFont());
            } else if (object == this.fixedfont) {
                JReqTools.showMessage("It may last a long time to pop up the requester.\nI am working on a solution for this problem.\n\nClick to continue ...");
                this.fixedFontRequester.setFixedWidthOnly(true);
                this.fixedFontRequester.request(this);
                this.fixedfont.setText(this.fixedFontRequester.getFontAsString());
                this.fixedfont.setFont(this.fixedFontRequester.getFont());
            } else if (object == this.largefont) {
                this.largeFontRequester.request(this);
                this.largefont.setText(this.largeFontRequester.getFontAsString());
                this.largefont.setFont(this.largeFontRequester.getFont());
            } else if (object == this.smallfont) {
                this.smallFontRequester.request(this);
                this.smallfont.setText(this.smallFontRequester.getFontAsString());
                this.smallfont.setFont(this.smallFontRequester.getFont());
            } else if (object == this.buttons) {
                this.setVisible(false);
                if (this.buttons.get() == 0) {
                    this.save();
                }
                Prefs.save();
                System.exit(0);
            } else if (object == this.save) {
                this.save();
            } else if (object == this.quit) {
                Prefs.save();
                System.exit(0);
            } else if (object == this.savedValues) {
                this.lastSaved();
            } else if (object == this.defaultValues) {
                this.defaultValues();
            }
        }

        private Panel createColorsPanel() {
            Panel panel = new Panel(new GridLayout(3, 2, Prefs.getObjectSpace(), Prefs.getObjectSpace()));
            panel.add(new Label(Prefs.getResourceString("PrefsFrame.Label1"), 2));
            panel.add(this.highlightColor);
            panel.add(new Label(Prefs.getResourceString("PrefsFrame.Label2"), 2));
            panel.add(this.highlightTextColor);
            panel.add(new Label(Prefs.getResourceString("PrefsFrame.Label3"), 2));
            panel.add(this.caretColor);
            YFramePanel yFramePanel = new YFramePanel();
            yFramePanel.add(Box.createVerticalGlue());
            yFramePanel.add(panel);
            yFramePanel.add(Box.createVerticalGlue());
            return yFramePanel;
        }

        private Panel createFontPanel() {
            Panel panel = new Panel(new GridLayout(4, 2, Prefs.getObjectSpace(), Prefs.getObjectSpace()));
            panel.add(new Label(Prefs.getResourceString("PrefsFrame.Label4"), 2));
            panel.add(this.normalfont);
            panel.add(new Label(Prefs.getResourceString("PrefsFrame.Label5"), 2));
            panel.add(this.fixedfont);
            panel.add(new Label(Prefs.getResourceString("PrefsFrame.Label11"), 2));
            panel.add(this.largefont);
            panel.add(new Label(Prefs.getResourceString("PrefsFrame.Label6"), 2));
            panel.add(this.smallfont);
            YFramePanel yFramePanel = new YFramePanel();
            yFramePanel.add(Box.createVerticalGlue());
            yFramePanel.add(panel);
            yFramePanel.add(Box.createVerticalGlue());
            return yFramePanel;
        }

        private Panel createLayoutPanel() {
            YFramePanel yFramePanel = new YFramePanel();
            yFramePanel.add(Box.createVerticalGlue());
            yFramePanel.add(new Label(Prefs.getResourceString("PrefsFrame.Label7")));
            yFramePanel.add(this.objectSpace);
            yFramePanel.add(new Strut());
            yFramePanel.add(new Label(Prefs.getResourceString("PrefsFrame.Label8")));
            yFramePanel.add(this.frameSpace);
            yFramePanel.add(new Strut());
            yFramePanel.add(this.useIcons);
            yFramePanel.add(new Strut());
            yFramePanel.add(Box.createVerticalGlue());
            return yFramePanel;
        }

        private Panel createLookAndFeelPanel() {
            YFramePanel yFramePanel = new YFramePanel();
            yFramePanel.add(Box.createVerticalGlue());
            yFramePanel.add(new Label(Prefs.getResourceString("PrefsFrame.Label9")));
            yFramePanel.add(this.lookandfeel);
            yFramePanel.add(Box.createVerticalGlue());
            return yFramePanel;
        }

        private Panel createTimeZonePanel() {
            Box box = Box.createHorizontalBox();
            box.add(this.timezone);
            box.add(new Strut());
            box.add(this.time);
            YFramePanel yFramePanel = new YFramePanel();
            yFramePanel.add(Box.createVerticalGlue());
            yFramePanel.add(new Label(Prefs.getResourceString("PrefsFrame.Label10")));
            yFramePanel.add(box);
            yFramePanel.add(Box.createVerticalGlue());
            this.timezone.addActionListener(new ActionListener(this){
                private final /* synthetic */ PrefsFrame this$0;
                {
                    this.this$0 = prefsFrame;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    TimeZone.setDefault(TimeZone.getTimeZone((String)this.this$0.timezone.getSelectedItem()));
                }
            });
            this.time.setBorder(true);
            new Timer(1000, new ActionListener(this){
                private final /* synthetic */ PrefsFrame this$0;
                {
                    this.this$0 = prefsFrame;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$0.time.setText(new Date().toString());
                }
            }).start();
            return yFramePanel;
        }

        private Panel createToolTipsPanel() {
            YFramePanel yFramePanel = new YFramePanel();
            yFramePanel.add(Box.createVerticalGlue());
            yFramePanel.add(this.tooltips);
            yFramePanel.add(Box.createVerticalGlue());
            return yFramePanel;
        }

        private void defaultValues() {
            this.normalFontRequester.setFont(Prefs.getDefaultNormalFont());
            this.fixedFontRequester.setFont(Prefs.getDefaultFixedFont());
            this.largeFontRequester.setFont(Prefs.getDefaultLargeFont());
            this.smallFontRequester.setFont(Prefs.getDefaultSmallFont());
            this.normalfont.setText(this.normalFontRequester.getFontAsString());
            this.fixedfont.setText(this.fixedFontRequester.getFontAsString());
            this.largefont.setText(this.largeFontRequester.getFontAsString());
            this.smallfont.setText(this.smallFontRequester.getFontAsString());
            this.normalfont.setFont(this.normalFontRequester.getFont());
            this.fixedfont.setFont(this.fixedFontRequester.getFont());
            this.largefont.setFont(this.largeFontRequester.getFont());
            this.smallfont.setFont(this.smallFontRequester.getFont());
            this.timezone.setSelectedItem(Prefs.getDefaultTimeZone());
            this.lookandfeel.setSelectedItem(Prefs.getDefaultLookAndFeel());
            this.objectSpace.setValue(Prefs.getDefaultObjectSpace());
            this.frameSpace.setValue(Prefs.getDefaultFrameSpace());
            this.useIcons.setSelected(Prefs.getDefaultUseIconsInTextButtons());
            this.tooltips.setSelected(Prefs.getDefaultShowToolTips());
            this.highlightColor.set(Prefs.getDefaultHighlightColor());
            this.highlightTextColor.set(Prefs.getDefaultHighlightTextColor());
            this.caretColor.set(Prefs.getDefaultCaretColor());
        }

        private Font getFont(String string) {
            if (string.equals("NormalFont")) {
                return this.normalFontRequester.getFont();
            }
            if (string.equals("FixedFont")) {
                return this.fixedFontRequester.getFont();
            }
            if (string.equals("LargeFont")) {
                return this.largeFontRequester.getFont();
            }
            return this.smallFontRequester.getFont();
        }

        public static final String[] getTimeZones() {
            String[] stringArray = TimeZone.getAvailableIDs();
            Vector<String> vector = new Vector<String>();
            Vector<String> vector2 = new Vector<String>();
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].indexOf("/") == -1) {
                    vector.addElement(stringArray[n]);
                } else {
                    vector2.addElement(stringArray[n]);
                }
                ++n;
            }
            Object[] objectArray = new String[vector.size()];
            Object[] objectArray2 = new String[vector2.size()];
            vector.copyInto(objectArray);
            vector2.copyInto(objectArray2);
            Sorter.sort((String[])objectArray);
            Sorter.sort((String[])objectArray2);
            System.arraycopy(objectArray, 0, stringArray, 0, objectArray.length);
            System.arraycopy(objectArray2, 0, stringArray, objectArray.length, objectArray2.length);
            return stringArray;
        }

        private void lastSaved() {
            this.normalFontRequester.setFont(Prefs.getNormalFont());
            this.fixedFontRequester.setFont(Prefs.getFixedFont());
            this.largeFontRequester.setFont(Prefs.getLargeFont());
            this.smallFontRequester.setFont(Prefs.getSmallFont());
            this.normalfont.setText(this.normalFontRequester.getFontAsString());
            this.fixedfont.setText(this.fixedFontRequester.getFontAsString());
            this.largefont.setText(this.largeFontRequester.getFontAsString());
            this.smallfont.setText(this.smallFontRequester.getFontAsString());
            this.normalfont.setFont(this.normalFontRequester.getFont());
            this.fixedfont.setFont(this.fixedFontRequester.getFont());
            this.largefont.setFont(this.largeFontRequester.getFont());
            this.smallfont.setFont(this.smallFontRequester.getFont());
            this.timezone.setSelectedItem(Prefs.getTimeZone());
            String string = null;
            String string2 = Prefs.getLookAndFeel();
            int n = 0;
            while (n < lookAndFeelClassNames.length) {
                string = lookAndFeelNames[n];
                if (string2.equals(lookAndFeelClassNames[n])) break;
                ++n;
            }
            this.lookandfeel.setSelectedItem(string);
            this.objectSpace.setValue(Prefs.getObjectSpace());
            this.frameSpace.setValue(Prefs.getFrameSpace());
            this.useIcons.setSelected(Prefs.getUseIconsInTextButtons());
            this.tooltips.setSelected(Prefs.getShowToolTips());
            this.highlightColor.set(Prefs.getHighlightColor());
            this.highlightTextColor.set(Prefs.getHighlightTextColor());
            this.caretColor.set(Prefs.getCaretColor());
        }

        private void save() {
            try {
                swingprefs.put("NormalFont", this.getFont("NormalFont"));
                swingprefs.put("FixedFont", this.getFont("FixedFont"));
                swingprefs.put("SmallFont", this.getFont("SmallFont"));
                swingprefs.put("LargeFont", this.getFont("LargeFont"));
                swingprefs.put("ShowToolTips", new Boolean(this.tooltips.isSelected()));
                swingprefs.put("UseIconsInTextButtons", new Boolean(this.useIcons.isSelected()));
                swingprefs.put("ObjectSpace", new Integer(this.objectSpace.getValue()));
                swingprefs.put("FrameSpace", new Integer(this.frameSpace.getValue()));
                swingprefs.put("LookAndFeel", lookAndFeelClassNames[this.lookandfeel.getSelectedIndex()]);
                swingprefs.put("TimeZone", this.timezone.getSelectedItem());
                swingprefs.put("HighlightColor", this.highlightColor.get());
                swingprefs.put("HighlightTextColor", this.highlightTextColor.get());
                swingprefs.put("CaretColor", this.caretColor.get());
                Prefs.savePrefs();
            }
            catch (Throwable throwable) {
                JReqTools.showException(throwable);
            }
        }
    }

    static final class Initializer {
        Text message;
        JLabel image;
        JFrame frame;
        JWindow window;

        public Initializer(Icon icon, boolean bl, boolean bl2) {
            this.image = new JLabel(icon);
            this.message = new Text(Prefs.getResourceString("Starting"), 0);
            this.message.setBackground(Color.black);
            this.message.setForeground(Color.white);
            this.message.setFont(Prefs.getNormalFont());
            if (bl) {
                this.frame = new JFrame(appname);
                Container container = this.frame.getContentPane();
                container.setLayout(new BorderLayout());
                container.add((Component)this.image, "Center");
                if (bl2) {
                    container.add((Component)this.message, "South");
                }
                this.frame.pack();
                Dimension dimension = this.frame.getSize();
                Dimension dimension2 = this.frame.getToolkit().getScreenSize();
                ((Component)this.frame).setLocation((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2);
                this.frame.setResizable(false);
                this.frame.setDefaultCloseOperation(0);
                this.frame.addWindowListener(new WindowAdapter(this){
                    private final /* synthetic */ Initializer this$0;
                    {
                        this.this$0 = initializer;
                    }

                    public void windowClosing(WindowEvent windowEvent) {
                        System.exit(0);
                    }
                });
            } else {
                this.window = new JWindow();
                Container container = this.window.getContentPane();
                container.setLayout(new BorderLayout());
                container.add((Component)this.image, "Center");
                if (bl2) {
                    container.add((Component)this.message, "South");
                }
                this.window.pack();
                Dimension dimension = this.window.getSize();
                Dimension dimension3 = this.window.getToolkit().getScreenSize();
                ((Component)this.window).setLocation((dimension3.width - dimension.width) / 2, (dimension3.height - dimension.height) / 2);
            }
            this.setVisible(true);
        }

        public void setVisible(boolean bl) {
            if (this.frame != null) {
                ((Component)this.frame).setVisible(bl);
            } else if (this.window != null) {
                ((Component)this.window).setVisible(bl);
            }
        }
    }
}

