/*
 * Decompiled with CFR 0.152.
 */
package swing.addon;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.JComponent;
import swing.addon.Prefs;

public class Separator
extends JComponent {
    private static final boolean DEBUG = false;
    public Object userData;
    String title;

    public Separator() {
        this(null);
    }

    public Separator(String string) {
        this.title = string;
        this.setFont(Prefs.getSmallFont());
        FontMetrics fontMetrics = ((Component)this).getFontMetrics(this.getFont());
        this.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.title == null ? 4 : fontMetrics.getHeight() + 2));
        this.setMinimumSize(new Dimension(10, this.title == null ? 4 : fontMetrics.getHeight() + 2));
        this.setPreferredSize(new Dimension(50, this.title == null ? 4 : fontMetrics.getHeight() + 2));
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        int n = dimension.height / 2 - 1;
        graphics.setColor(Color.black);
        graphics.drawLine(0, n, dimension.width, n);
        graphics.setColor(Color.white);
        graphics.drawLine(0, n + 1, dimension.width, n + 1);
        if (this.title == null) {
            return;
        }
        FontMetrics fontMetrics = ((Component)this).getFontMetrics(this.getFont());
        int n2 = fontMetrics.stringWidth(this.title);
        graphics.setColor(this.getBackground());
        graphics.fillRect((dimension.width - n2 - 10) / 2, 0, n2 + 10, dimension.height);
        graphics.setFont(this.getFont());
        graphics.setColor(Color.black);
        graphics.drawString(this.title, (dimension.width - n2 - 10) / 2 + 5, fontMetrics.getAscent());
    }

    public void set(String string) {
        this.title = string;
        this.repaint();
    }
}

