/*
 * Decompiled with CFR 0.152.
 */
package swing.addon;

import java.awt.Dimension;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class Table
extends JScrollPane {
    private static final boolean DEBUG = false;
    public Object userData;
    String[] headers;
    JTable table;
    MyTableModel model;
    Vector data = new Vector(10, 10);

    public Table() {
        this.table = new JTable();
        this.table.setPreferredScrollableViewportSize(new Dimension(200, 50));
        this.table.setAlignmentX(0.5f);
        this.table.setAlignmentY(0.5f);
        this.table.getSelectionModel().setSelectionMode(0);
        this.getViewport().setView(this.table);
    }

    public Table(String[] stringArray) {
        this.headers = stringArray;
        this.model = new MyTableModel();
        this.table = new JTable(this.model);
        this.table.setPreferredScrollableViewportSize(new Dimension(200, 50));
        this.table.setAlignmentX(0.5f);
        this.table.setAlignmentY(0.5f);
        this.table.getSelectionModel().setSelectionMode(0);
        this.getViewport().setView(this.table);
    }

    public synchronized int addItem(Object[] objectArray) {
        if (objectArray.length < this.model.getColumnCount()) {
            throw new RuntimeException(this.getClass().getName() + ".addItem(): not enough columns");
        }
        this.data.addElement(objectArray);
        this.model.fire();
        return this.data.size() - 1;
    }

    public synchronized int addItemSorted(Object[] objectArray) {
        if (objectArray.length < this.model.getColumnCount()) {
            throw new RuntimeException(this.getClass().getName() + ".addItem(): not enough columns");
        }
        int n = 0;
        int n2 = this.data.size();
        n = 0;
        while (n < n2 && ((Object[])this.data.elementAt(n))[0].toString().compareTo(objectArray[0].toString()) < 0) {
            ++n;
        }
        this.data.insertElementAt(objectArray, n);
        this.model.fire();
        return n;
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this.table.getSelectionModel().addListSelectionListener(listSelectionListener);
    }

    public void addMouseListener(MouseListener mouseListener) {
        this.table.addMouseListener(mouseListener);
    }

    public synchronized void clear() {
        this.table.getSelectionModel().clearSelection();
        this.data.setSize(0);
        this.model.fire();
    }

    public Enumeration elements() {
        return this.data.elements();
    }

    public TableModel getModel() {
        return this.model;
    }

    public Object[] getSelectedItem() {
        int n = this.getSelectedRow();
        if (n < 0 || n >= this.data.size()) {
            return null;
        }
        return (Object[])this.data.elementAt(n);
    }

    public int getSelectedRow() {
        return this.table.getSelectedRow();
    }

    public synchronized int removeItem(Object[] objectArray) {
        this.data.removeElement(objectArray);
        this.model.fire();
        return this.data.size();
    }

    public synchronized Object[] removeSelectedItem() {
        Object[] objectArray = this.getSelectedItem();
        if (objectArray == null) {
            return null;
        }
        this.removeItem(objectArray);
        return objectArray;
    }

    public void setDefaultRenderer(Class clazz, TableCellRenderer tableCellRenderer) {
        this.table.setDefaultRenderer(clazz, tableCellRenderer);
    }

    public void setMaxWidthForColumn(int n, int n2) {
        this.table.getColumnModel().getColumn(n).setMaxWidth(n2);
    }

    public void setMinWidthForColumn(int n, int n2) {
        this.table.getColumnModel().getColumn(n).setMinWidth(n2);
    }

    public void setModel(TableModel tableModel) {
        this.table.setModel(tableModel);
    }

    public void setPreferredWidthForColumn(int n, int n2) {
        this.table.getColumnModel().getColumn(n).setPreferredWidth(n2);
    }

    public void setSelectedRow(int n) {
        this.table.getSelectionModel().setSelectionInterval(n, n);
    }

    public synchronized void sort(int n) {
        Vector<Object[]> vector = new Vector<Object[]>(this.data.size(), 10);
        while (this.data.size() > 0) {
            Object[] objectArray = (Object[])this.data.elementAt(0);
            int n2 = 0;
            while (n2 < vector.size() && ((Object[])vector.elementAt(n2))[n].toString().compareTo(objectArray[n].toString()) < 0) {
                ++n2;
            }
            vector.insertElementAt(objectArray, n2);
            this.data.removeElementAt(0);
        }
        this.data = vector;
        this.model.fire();
    }

    private class MyTableModel
    extends AbstractTableModel {
        private MyTableModel() {
        }

        public void fire() {
            this.fireTableDataChanged();
        }

        public int getColumnCount() {
            return Table.this.headers.length;
        }

        public String getColumnName(int n) {
            return Table.this.headers[n];
        }

        public int getRowCount() {
            Vector vector = Table.this.data;
            synchronized (vector) {
                int n = Table.this.data.size();
                return n;
            }
        }

        public Object getValueAt(int n, int n2) {
            Vector vector = Table.this.data;
            synchronized (vector) {
                Object object = ((Object[])Table.this.data.elementAt(n))[n2];
                return object;
            }
        }
    }
}

