/*
 * Decompiled with CFR 0.152.
 */
package swing.addon;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.TextAction;
import jreqtools.FileFilter;
import jreqtools.FileRequester;
import jreqtools.JReqTools;
import swing.addon.Button;
import swing.addon.CheckBox;
import swing.addon.ComboBox;
import swing.addon.EditorPane;
import swing.addon.Frame;
import swing.addon.GUISystem;
import swing.addon.InsertChar1;
import swing.addon.InsertChar2;
import swing.addon.InsertChar3;
import swing.addon.InsertChar4;
import swing.addon.InsertChar5;
import swing.addon.InsertChar6;
import swing.addon.InsertChar7;
import swing.addon.KeyStrokeComponent;
import swing.addon.Label;
import swing.addon.OkCancelButtons;
import swing.addon.Panel;
import swing.addon.Prefs;
import swing.addon.Separator;
import swing.addon.Slider;
import swing.addon.Strut;
import swing.addon.TabbedPane;
import swing.addon.Table;
import swing.addon.Text;
import swing.addon.ToolBar;
import swing.addon.YFramePanel;
import swing.addon.text.UndoableDocument;
import swing.addon.util.Sorter;

public class TextEditor
extends JPanel {
    private static final boolean DEBUG = false;
    public Object userData;
    protected EditorPane editor;
    protected JScrollPane scroller;
    private static Hashtable keystrokes = new Hashtable(10, 10.0f);
    private static Hashtable prefs = new Hashtable(10, 10.0f);
    private Hashtable positions = new Hashtable(50, 50.0f);
    private static Vector editors = new Vector(10, 10);
    private static boolean useFixedFont = false;
    private static int counter = 0;
    private ToolBar toolbar = null;
    Action[] globalActions = this.initActions();
    Action[] localActions = new Action[0];

    public TextEditor() {
        ++counter;
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(200, 200));
        this.setMinimumSize(new Dimension(100, 100));
        this.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.editor = new EditorPane();
        this.scroller = new JScrollPane(this.editor);
        this.add((Component)this.scroller, "Center");
        editors.addElement(this);
        Keymap keymap = this.editor.getKeymap();
        KeyStroke[] keyStrokeArray = keymap.getBoundKeyStrokes();
        if (keystrokes.isEmpty()) {
            int n = 0;
            while (n < keyStrokeArray.length) {
                keystrokes.put(keyStrokeArray[n], keymap.getAction(keyStrokeArray[n]).getValue("Name"));
                ++n;
            }
        }
        keymap.removeBindings();
        this.setKeyStrokes();
        this.editor.setFont(TextEditor.isUsingFixedFont() ? Prefs.getFixedFont() : Prefs.getNormalFont());
        this.setDocument(new UndoableDocument());
    }

    public void addAction(Action action) {
        String string = (String)action.getValue("Name");
        Action action2 = this.getAction(string);
        if (action2 != null) {
            GUISystem.err.println(this.getClass().getName() + ".addAction(): action '" + action2 + "' already present in " + this);
            return;
        }
        Action[] actionArray = this.localActions;
        this.localActions = new Action[actionArray.length + 1];
        System.arraycopy(actionArray, 0, this.localActions, 0, actionArray.length);
        this.localActions[actionArray.length] = action;
        this.setKeyStrokes();
    }

    public void addActions(Action[] actionArray) {
        int n = 0;
        while (n < actionArray.length) {
            if (actionArray[n] != null) {
                this.addAction(actionArray[n]);
            }
            ++n;
        }
    }

    public Action getAction(String string) {
        Action action = this.editor.getAction(string);
        if (action != null) {
            return action;
        }
        int n = 0;
        while (n < this.globalActions.length) {
            action = this.globalActions[n];
            if (action.getValue("Name").equals(string)) {
                return action;
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < this.localActions.length) {
            action = this.localActions[n2];
            if (action.getValue("Name").equals(string)) {
                return action;
            }
            ++n2;
        }
        return null;
    }

    public Action[] getActions() {
        return TextAction.augmentList(TextAction.augmentList(this.editor.getActions(), this.globalActions), this.localActions);
    }

    public int getCaretPosition() {
        return this.editor.getCaretPosition();
    }

    public ToolBar getDefaultToolBar() {
        ToolBar toolBar = new ToolBar();
        toolBar.add(this.getAction("cut-to-clipboard"));
        toolBar.add(this.getAction("copy-to-clipboard"));
        toolBar.add(this.getAction("paste-from-clipboard"));
        toolBar.addSeparator();
        toolBar.add(this.getAction("undo"));
        toolBar.add(this.getAction("redo"));
        toolBar.addSeparator();
        toolBar.add(this.getAction("sort-increasing"));
        toolBar.add(this.getAction("sort-decreasing"));
        toolBar.addSeparator();
        return toolBar;
    }

    public Document getDocument() {
        return this.editor.getDocument();
    }

    public EditorKit getEditorKit() {
        return this.editor.getEditorKit();
    }

    public static synchronized Hashtable getKeyStrokes() {
        return (Hashtable)keystrokes.clone();
    }

    public String getSelectedText() {
        return this.editor.getSelectedText();
    }

    public int getSelectionEnd() {
        return this.editor.getSelectionEnd();
    }

    public int getSelectionStart() {
        return this.editor.getSelectionStart();
    }

    public static int getTabWidth() {
        Integer n = (Integer)prefs.get("TABWIDTH");
        return n == null ? 25 : n;
    }

    public String getText() {
        return this.editor.getText();
    }

    public String getText(int n, int n2) {
        try {
            return this.editor.getText(n, n2);
        }
        catch (BadLocationException badLocationException) {
            JReqTools.showException(badLocationException);
            return "";
        }
    }

    public JTextComponent getTextComponent() {
        return this.editor;
    }

    public ToolBar getToolBar() {
        return this.toolbar;
    }

    public Point getViewPosition() {
        return this.scroller.getViewport().getViewPosition();
    }

    private Action[] initActions() {
        if (Prefs.isWindowsSystem()) {
            return new Action[]{new UndoAction(), new RedoAction(), new PrefsAction(), new SortIncreasingAction(), new SortDecreasingAction(), new AutoIndentAction1(), new AutoIndentAction2(), new InsertChar1(), new InsertChar2(), new InsertChar3(), new InsertChar4(), new InsertChar5(), new InsertChar6(), new InsertChar7()};
        }
        return new Action[]{new UndoAction(), new RedoAction(), new SortIncreasingAction(), new SortDecreasingAction(), new PrefsAction(), new AutoIndentAction1(), new AutoIndentAction2()};
    }

    public void insertText(String string) {
        this.editor.replaceSelection(string);
    }

    public static boolean isUsingFixedFont() {
        Boolean bl = (Boolean)prefs.get("USEFIXEDFONT");
        return bl == null ? false : bl;
    }

    public void replaceSelection(String string) {
        this.editor.replaceSelection(string);
    }

    public void requestFocus() {
        this.editor.requestFocus();
    }

    public void select(int n, int n2) {
        this.editor.select(n, n2);
    }

    public void setCaretPosition(int n) {
        this.editor.setCaretPosition(n);
    }

    public void setDocument(Document document) {
        Document document2 = this.editor.getDocument();
        this.positions.put(document2, new Data(this.editor.getCaretPosition(), this.scroller.getViewport().getViewPosition()));
        this.editor.setDocument(document);
        Data data = (Data)this.positions.get(document);
        if (data != null) {
            try {
                this.editor.setCaretPosition(data.caretPosition);
                this.scroller.getViewport().setViewPosition(data.viewPosition);
            }
            catch (Throwable throwable) {
                JReqTools.showException(throwable);
            }
        }
        this.scroller.validate();
    }

    public void setEditable(boolean bl) {
        this.editor.setEditable(bl);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.editor.setEnabled(bl);
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.editor != null) {
            this.editor.setFont(font);
        }
    }

    private void setKeyStrokes() {
        Keymap keymap = this.editor.getKeymap();
        keymap.removeBindings();
        Enumeration enumeration = keystrokes.keys();
        while (enumeration.hasMoreElements()) {
            KeyStroke keyStroke = (KeyStroke)enumeration.nextElement();
            Action action = this.getAction((String)keystrokes.get(keyStroke));
            if (action == null) continue;
            keymap.addActionForKeyStroke(keyStroke, action);
        }
    }

    public static synchronized void setKeyStrokes(Hashtable hashtable) {
        Enumeration<Object> enumeration;
        keystrokes.clear();
        Enumeration enumeration2 = hashtable.keys();
        while (enumeration2.hasMoreElements()) {
            enumeration = enumeration2.nextElement();
            if (enumeration instanceof KeyStroke) {
                keystrokes.put(enumeration, hashtable.get(enumeration));
                continue;
            }
            throw new IllegalArgumentException("TextEditor.setKeyStrokes(): " + enumeration + " is not instanceof KeyStroke");
        }
        enumeration = editors.elements();
        while (enumeration.hasMoreElements()) {
            TextEditor textEditor = (TextEditor)enumeration.nextElement();
            textEditor.setKeyStrokes();
        }
    }

    public static void setTabWidth(int n) {
        prefs.put("TABWIDTH", new Integer(n));
        Enumeration enumeration = editors.elements();
        while (enumeration.hasMoreElements()) {
            TextEditor textEditor = (TextEditor)enumeration.nextElement();
            textEditor.repaint();
        }
    }

    public void setText(String string) {
        this.editor.setText(string);
    }

    public void setToolBar(ToolBar toolBar) {
        this.toolbar = toolBar;
        this.add((Component)this.toolbar, "North");
    }

    public static void setUseFixedFont(boolean bl) {
        prefs.put("USEFIXEDFONT", new Boolean(bl));
        Enumeration enumeration = editors.elements();
        while (enumeration.hasMoreElements()) {
            TextEditor textEditor = (TextEditor)enumeration.nextElement();
            textEditor.editor.setFont(bl ? Prefs.getFixedFont() : Prefs.getNormalFont());
            textEditor.repaint();
        }
    }

    public void setViewPosition(Point point) {
        this.scroller.getViewport().setViewPosition(point);
    }

    public String toString() {
        return this.getClass().getName() + "#" + counter;
    }

    static {
        Prefs.add("JavaEditor.Prefs", prefs);
        Prefs.add("JavaEditor.KeyStrokes", keystrokes);
    }

    public class UndoAction
    extends TextAction {
        public UndoAction() {
            super("undo");
            this.putValue("ShortDescription", Prefs.getResourceString("TextEditor.UndoAction.Description"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                JTextComponent jTextComponent = this.getFocusedComponent();
                if (jTextComponent == null) {
                    TextEditor.this.getToolkit().beep();
                    return;
                }
                UndoableDocument undoableDocument = (UndoableDocument)jTextComponent.getDocument();
                if (undoableDocument.canUndo()) {
                    undoableDocument.undo();
                } else {
                    TextEditor.this.getToolkit().beep();
                }
            }
            catch (Exception exception) {
                GUISystem.err.println(exception.getLocalizedMessage());
            }
        }
    }

    public class SortIncreasingAction
    extends TextAction {
        public SortIncreasingAction() {
            super("sort-increasing");
            this.putValue("ShortDescription", Prefs.getResourceString("TextEditor.SortIncreasingAction.Description"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getFocusedComponent();
            if (jTextComponent == null) {
                TextEditor.this.getToolkit().beep();
                return;
            }
            int n = jTextComponent.getSelectionStart();
            if (n < 0) {
                TextEditor.this.getToolkit().beep();
                return;
            }
            int n2 = jTextComponent.getSelectionEnd();
            if (n2 < 0) {
                TextEditor.this.getToolkit().beep();
                return;
            }
            int n3 = jTextComponent.getCaretPosition();
            String string = jTextComponent.getText();
            String string2 = string.substring(0, n);
            String string3 = this.sort(string.substring(n, n2));
            String string4 = string.substring(n2);
            try {
                jTextComponent.setText(string2 + string3 + string4);
                jTextComponent.setCaretPosition(n3);
                jTextComponent.select(n, n2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        protected String sort(String string) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
            String[] stringArray = new String[stringTokenizer.countTokens()];
            int n = 0;
            while (n < stringArray.length) {
                stringArray[n] = stringTokenizer.nextToken();
                ++n;
            }
            Sorter.sort(stringArray);
            StringBuffer stringBuffer = new StringBuffer(string.length());
            int n2 = 0;
            while (n2 < stringArray.length) {
                stringBuffer.append(stringArray[n2] + "\n");
                ++n2;
            }
            if (!string.endsWith("\n")) {
                stringBuffer.setLength(stringBuffer.length() - 1);
            }
            return stringBuffer.toString();
        }
    }

    public class SortDecreasingAction
    extends SortIncreasingAction {
        public SortDecreasingAction() {
            this.putValue("Name", "sort-decreasing");
            this.putValue("ShortDescription", Prefs.getResourceString("TextEditor.SortDecreasingAction.Description"));
        }

        protected String sort(String string) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
            String[] stringArray = new String[stringTokenizer.countTokens()];
            int n = 0;
            while (n < stringArray.length) {
                stringArray[n] = stringTokenizer.nextToken();
                ++n;
            }
            Sorter.sort(stringArray);
            StringBuffer stringBuffer = new StringBuffer(string.length());
            int n2 = stringArray.length;
            while (n2 > 0) {
                stringBuffer.append(stringArray[n2 - 1] + "\n");
                --n2;
            }
            if (!string.endsWith("\n")) {
                stringBuffer.setLength(stringBuffer.length() - 1);
            }
            return stringBuffer.toString();
        }
    }

    public class RedoAction
    extends TextAction {
        public RedoAction() {
            super("redo");
            this.putValue("ShortDescription", Prefs.getResourceString("TextEditor.RedoAction.Description"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                JTextComponent jTextComponent = this.getFocusedComponent();
                if (jTextComponent == null) {
                    TextEditor.this.getToolkit().beep();
                    return;
                }
                UndoableDocument undoableDocument = (UndoableDocument)jTextComponent.getDocument();
                if (undoableDocument.canRedo()) {
                    undoableDocument.redo();
                } else {
                    TextEditor.this.getToolkit().beep();
                }
            }
            catch (Exception exception) {
                GUISystem.err.println(exception.getLocalizedMessage());
            }
        }
    }

    public class PrefsAction
    extends AbstractAction {
        Frame frame;

        public PrefsAction() {
            super("text-editor-prefs");
            this.putValue("ShortDescription", Prefs.getResourceString("TextEditor.PrefsAction.Description"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.frame == null) {
                this.frame = new PrefsFrame();
            }
            this.frame.setVisible(true);
        }

        class PrettyAction
        implements Sorter.Comparable {
            Action action;

            PrettyAction(Action action) {
                this.action = action;
            }

            public int compareTo(Object object) {
                return this.toString().compareTo(object.toString());
            }

            public boolean equals(Object object) {
                return this.compareTo(object) == 0;
            }

            public String toString() {
                return (String)this.action.getValue("Name");
            }
        }

        class PrefsFrame
        extends Frame
        implements ActionListener {
            KeyStrokeComponent keystroke = new KeyStrokeComponent();
            ComboBox actions = new ComboBox(this.createPrettyActions());
            Button add = new Button(Prefs.getResourceString("TextEditor.PrefsFrame.Add"));
            Button remove = new Button(Prefs.getResourceString("TextEditor.PrefsFrame.Remove"));
            Slider tabwidth = new Slider(0, 10, 210, 25);
            Text tabwidthtext = new Text("", 0);
            Text description = new Text("");
            CheckBox fixedfont = new CheckBox(Prefs.getResourceString("TextEditor.PrefsFrame.FixedFont"));
            OkCancelButtons buttons = new OkCancelButtons(Prefs.getResourceString("Apply"), Prefs.getResourceString("Cancel"));
            FileRequester fileRequester = new FileRequester();
            Button load = new Button(Prefs.getResourceString("TextEditor.PrefsFrame.Load"));
            Button save = new Button(Prefs.getResourceString("TextEditor.PrefsFrame.Save"));
            Table keytable = new Table(new String[]{Prefs.getResourceString("TextEditor.PrefsFrame.Table.1"), Prefs.getResourceString("TextEditor.PrefsFrame.Table.1")});

            public PrefsFrame() {
                super(Prefs.getResourceString("TextEditor.PrefsFrame.Title"));
                this.description.setBorder(true);
                this.fileRequester.addChoosableFileFilter(new FileFilter.SuffixFileFilter("kbd", Prefs.getResourceString("TextEditor.PrefsFrame.KBD")), true);
                this.setValues();
                this.add.addActionListener(this);
                this.remove.addActionListener(this);
                this.actions.addActionListener(this);
                this.buttons.addActionListener(this);
                this.load.addActionListener(this);
                this.save.addActionListener(this);
                YFramePanel yFramePanel = new YFramePanel();
                yFramePanel.add(this.createTabbedPane());
                yFramePanel.add(new Strut());
                yFramePanel.add(this.buttons);
                this.setContentPane(yFramePanel);
                this.pack();
                Prefs.add("TextEditor.PrefsFrame", this);
                Prefs.add("TextEditor.FileRequester", this.fileRequester);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                if (object == this.actions) {
                    Object[] objectArray = this.keytable.getSelectedItem();
                    if (objectArray == null) {
                        this.actions.getToolkit().beep();
                        return;
                    }
                    objectArray[1] = this.actions.getSelectedItem();
                    this.keytable.repaint();
                    String string = (String)((PrettyAction)objectArray[1]).action.getValue("ShortDescription");
                    this.description.setText(string == null ? Prefs.getResourceString("TextEditor.PrefsFrame.NoDescription") : string);
                } else if (object == this.remove) {
                    int n = this.keytable.getSelectedRow();
                    Object[] objectArray = this.keytable.getSelectedItem();
                    if (objectArray == null) {
                        this.remove.getToolkit().beep();
                        return;
                    }
                    int n2 = this.keytable.removeItem(objectArray);
                    if (n2 > 0) {
                        this.keytable.setSelectedRow(n >= n2 ? n - 1 : n);
                    }
                } else if (object == this.add) {
                    int n = this.keytable.addItemSorted(new Object[]{KeyStroke.getKeyStroke(' '), new PrettyAction(TextEditor.this.getAction("undo"))});
                    this.keytable.setSelectedRow(n);
                    this.keystroke.requestFocus();
                } else if (object == this.load) {
                    this.fileRequester.setTitle(Prefs.getResourceString("TextEditor.PrefsFrame.LoadTitle"));
                    this.fileRequester.setLoadMode();
                    if (this.fileRequester.request(this) == 0) {
                        this.setValues(this.loadFromFile(this.fileRequester.getFile()));
                    }
                } else if (object == this.save) {
                    Object object2;
                    Hashtable<Object, String> hashtable = new Hashtable<Object, String>(10, 10.0f);
                    Enumeration enumeration = this.keytable.elements();
                    while (enumeration.hasMoreElements()) {
                        object2 = (Object[])enumeration.nextElement();
                        if (hashtable.get(object2[0]) != null) {
                            JReqTools.showError(Prefs.getResourceString("TextEditor.PrefsFrame.Duplicate", object2[0].toString()));
                            return;
                        }
                        hashtable.put(object2[0], ((PrettyAction)object2[1]).toString());
                    }
                    this.fileRequester.setTitle(Prefs.getResourceString("TextEditor.PrefsFrame.SaveTitle"));
                    this.fileRequester.setSaveMode();
                    if (this.fileRequester.request(this) == 0) {
                        object2 = this.fileRequester.getFile();
                        String string = ((File)object2).getAbsolutePath();
                        if (!string.endsWith(".kbd")) {
                            string = string + ".kbd";
                            object2 = new File(string);
                        }
                        this.saveToFile((File)object2, hashtable);
                    }
                } else if (object == this.buttons) {
                    if (this.buttons.get() == 0) {
                        Hashtable<Object, String> hashtable = new Hashtable<Object, String>(10, 10.0f);
                        Enumeration enumeration = this.keytable.elements();
                        while (enumeration.hasMoreElements()) {
                            Object[] objectArray = (Object[])enumeration.nextElement();
                            if (hashtable.get(objectArray[0]) != null) {
                                JReqTools.showError(Prefs.getResourceString("TextEditor.PrefsFrame.Duplicate", objectArray[0].toString()));
                                return;
                            }
                            hashtable.put(objectArray[0], ((PrettyAction)objectArray[1]).toString());
                        }
                        TextEditor.setKeyStrokes(hashtable);
                        TextEditor.setTabWidth(this.tabwidth.getValue());
                        TextEditor.setUseFixedFont(this.fixedfont.isSelected());
                    } else {
                        this.setValues();
                    }
                    this.setVisible(false);
                } else {
                    GUISystem.err.println(this.getClass().getName() + ".actionPerformed(): internal error");
                }
            }

            private Panel createFontPane() {
                YFramePanel yFramePanel = new YFramePanel();
                yFramePanel.add(Box.createVerticalGlue());
                yFramePanel.add(this.fixedfont);
                yFramePanel.add(Box.createVerticalGlue());
                return yFramePanel;
            }

            private Panel createKeyPane() {
                this.keytable.addListSelectionListener(new ListSelectionListener(this){
                    private final /* synthetic */ PrefsFrame this$2;
                    {
                        this.this$2 = prefsFrame;
                    }

                    public void valueChanged(ListSelectionEvent listSelectionEvent) {
                        Object[] objectArray = this.this$2.keytable.getSelectedItem();
                        if (objectArray == null) {
                            return;
                        }
                        this.this$2.keystroke.setKeyStroke((KeyStroke)objectArray[0]);
                        this.this$2.actions.setSelectedItem(objectArray[1]);
                        this.this$2.actions.repaint();
                        String string = (String)((PrettyAction)objectArray[1]).action.getValue("ShortDescription");
                        this.this$2.description.setText(string == null ? Prefs.getResourceString("TextEditor.PrefsFrame.NoDescription") : string);
                    }
                });
                this.keystroke.addChangeListener(new ChangeListener(this){
                    private final /* synthetic */ PrefsFrame this$2;
                    {
                        this.this$2 = prefsFrame;
                    }

                    public void stateChanged(ChangeEvent changeEvent) {
                        Object[] objectArray = this.this$2.keytable.getSelectedItem();
                        if (objectArray == null) {
                            this.this$2.keystroke.getToolkit().beep();
                            return;
                        }
                        objectArray[0] = this.this$2.keystroke.getKeyStroke();
                        this.this$2.keytable.repaint();
                    }
                });
                Box box = Box.createHorizontalBox();
                box.add(this.load);
                box.add(new Strut());
                box.add(this.save);
                box.add(new Strut());
                box.add(Box.createHorizontalGlue());
                box.add(new Strut());
                box.add(this.add);
                box.add(new Strut());
                box.add(this.remove);
                Box box2 = Box.createHorizontalBox();
                box2.add(this.keystroke);
                box2.add(new Strut());
                box2.add(this.actions);
                YFramePanel yFramePanel = new YFramePanel();
                yFramePanel.add(new Separator(Prefs.getResourceString("TextEditor.PrefsFrame.Separator1")));
                yFramePanel.add(this.keytable);
                yFramePanel.add(new Strut());
                yFramePanel.add(box);
                yFramePanel.add(new Strut());
                yFramePanel.add(new Separator(Prefs.getResourceString("TextEditor.PrefsFrame.Separator2")));
                yFramePanel.add(box2);
                yFramePanel.add(new Strut());
                yFramePanel.add(this.description);
                return yFramePanel;
            }

            private PrettyAction[] createPrettyActions() {
                Action[] actionArray = TextEditor.this.getActions();
                Sorter.Comparable[] comparableArray = new PrettyAction[actionArray.length];
                int n = 0;
                while (n < actionArray.length) {
                    comparableArray[n] = new PrettyAction(actionArray[n]);
                    ++n;
                }
                Sorter.sort(comparableArray);
                return comparableArray;
            }

            private TabbedPane createTabbedPane() {
                TabbedPane tabbedPane = new TabbedPane();
                tabbedPane.addTab(Prefs.getResourceString("TextEditor.PrefsFrame.TabbedPane.1"), this.createKeyPane());
                tabbedPane.addTab(Prefs.getResourceString("TextEditor.PrefsFrame.TabbedPane.2"), this.createTabulatorPane());
                tabbedPane.addTab(Prefs.getResourceString("TextEditor.PrefsFrame.TabbedPane.3"), this.createFontPane());
                return tabbedPane;
            }

            private Panel createTabulatorPane() {
                this.tabwidth.setMinorTickSpacing(5);
                this.tabwidth.setMajorTickSpacing(20);
                this.tabwidth.setPaintLabels(false);
                this.tabwidth.addChangeListener(new ChangeListener(this){
                    private final /* synthetic */ PrefsFrame this$2;
                    {
                        this.this$2 = prefsFrame;
                    }

                    public void stateChanged(ChangeEvent changeEvent) {
                        this.this$2.tabwidthtext.setText(Integer.toString(this.this$2.tabwidth.getValue()));
                    }
                });
                this.tabwidthtext.setBorder(true);
                YFramePanel yFramePanel = new YFramePanel();
                yFramePanel.add(Box.createVerticalGlue());
                yFramePanel.add(new Label(Prefs.getResourceString("TextEditor.PrefsFrame.Label1")));
                yFramePanel.add(this.tabwidth);
                yFramePanel.add(new Strut());
                yFramePanel.add(this.tabwidthtext);
                yFramePanel.add(Box.createVerticalGlue());
                return yFramePanel;
            }

            private Hashtable loadFromFile(File file) {
                Hashtable hashtable = new Hashtable();
                try {
                    ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(file));
                    Hashtable hashtable2 = (Hashtable)objectInputStream.readObject();
                    objectInputStream.close();
                    String string = (String)hashtable2.get("Key");
                    if (string != null && string.equals("TextEditorPrefs (kbd)")) {
                        hashtable2.remove("Key");
                        hashtable = hashtable2;
                    } else {
                        JReqTools.showError(Prefs.getResourceString("TextEditor.PrefsFrame.Error1"));
                    }
                }
                catch (Exception exception) {
                    JReqTools.showException(exception);
                }
                return hashtable;
            }

            private void saveToFile(File file, Hashtable hashtable) {
                hashtable.put("Key", "TextEditorPrefs (kbd)");
                try {
                    ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(file));
                    objectOutputStream.writeObject(hashtable);
                    objectOutputStream.flush();
                    objectOutputStream.close();
                }
                catch (IOException iOException) {
                    JReqTools.showException(iOException);
                }
            }

            void setValues() {
                this.setValues(TextEditor.getKeyStrokes());
            }

            private void setValues(Hashtable hashtable) {
                this.tabwidth.setValue(TextEditor.getTabWidth());
                this.tabwidthtext.setText(Integer.toString(TextEditor.getTabWidth()));
                this.keytable.clear();
                Hashtable hashtable2 = hashtable;
                Enumeration enumeration = hashtable2.keys();
                while (enumeration.hasMoreElements()) {
                    KeyStroke keyStroke = (KeyStroke)enumeration.nextElement();
                    Action action = TextEditor.this.getAction((String)hashtable2.get(keyStroke));
                    if (action == null) {
                        JReqTools.showMessage(Prefs.getResourceString("TextEditor.PrefsFrame.Error2", (String)hashtable2.get(keyStroke)));
                        continue;
                    }
                    this.keytable.addItemSorted(new Object[]{keyStroke, new PrettyAction(action)});
                }
                this.fixedfont.setSelected(TextEditor.isUsingFixedFont());
            }
        }
    }

    private final class Data {
        int caretPosition;
        Point viewPosition;

        public Data(int n, Point point) {
            this.caretPosition = n;
            this.viewPosition = point;
        }
    }

    public class AutoIndentAction2
    extends AbstractAction {
        public AutoIndentAction2() {
            super("insert-break (auto-indent mode 2)");
            this.putValue("ShortDescription", Prefs.getResourceString("TextEditor.AutoIndentAction2.Description"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                String string;
                JTextComponent jTextComponent = (JTextComponent)actionEvent.getSource();
                Document document = jTextComponent.getDocument();
                int n = jTextComponent.getCaretPosition();
                StringBuffer stringBuffer = new StringBuffer(50);
                int n2 = n - 1;
                while (n2 != -1) {
                    string = document.getText(n2, 1);
                    if (string.equals("\n")) break;
                    stringBuffer.insert(0, string);
                    --n2;
                }
                string = stringBuffer.toString();
                String string2 = "";
                n2 = 0;
                while (n2 < string.length() && Character.isWhitespace(string.charAt(n2))) {
                    string2 = string2 + string.charAt(n2);
                    ++n2;
                }
                String string3 = string.trim();
                if (string3.endsWith("}") && string2.length() > 0) {
                    string2 = string2.substring(0, string2.length() - 1);
                    document.insertString(n, "\n" + string2, null);
                } else {
                    document.insertString(n, "\n" + string2, null);
                }
            }
            catch (Exception exception) {
                GUISystem.err.println(exception);
            }
        }
    }

    public class AutoIndentAction1
    extends AbstractAction {
        public AutoIndentAction1() {
            super("insert-break (auto-indent mode 1)");
            this.putValue("ShortDescription", Prefs.getResourceString("TextEditor.AutoIndentAction1.Description"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                String string;
                JTextComponent jTextComponent = (JTextComponent)actionEvent.getSource();
                Document document = jTextComponent.getDocument();
                int n = jTextComponent.getCaretPosition();
                StringBuffer stringBuffer = new StringBuffer(50);
                int n2 = n - 1;
                while (n2 != -1) {
                    string = document.getText(n2, 1);
                    if (string.equals("\n")) break;
                    stringBuffer.insert(0, string);
                    --n2;
                }
                string = stringBuffer.toString();
                String string2 = "";
                n2 = 0;
                while (n2 < string.length() && Character.isWhitespace(string.charAt(n2))) {
                    string2 = string2 + string.charAt(n2);
                    ++n2;
                }
                String string3 = string.trim();
                if (string3.endsWith("{")) {
                    document.insertString(n, "\n" + string2 + "\t", null);
                } else if (string3.endsWith("}") && string2.length() > 0) {
                    string2 = string2.substring(0, string2.length() - 1);
                    document.insertString(n, "\n" + string2, null);
                } else {
                    document.insertString(n, "\n" + string2, null);
                }
            }
            catch (Exception exception) {
                GUISystem.err.println(exception);
            }
        }
    }
}

