/*
 * Decompiled with CFR 0.152.
 */
package swing.addon;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.image.AreaAveragingScaleFilter;
import java.awt.image.FilteredImageSource;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import swing.addon.Text;

public class Thumbnail
extends JLabel {
    private static final boolean DEBUG = false;
    public Object userData;
    int width;
    int height;
    JLabel label = new JLabel();
    Text text = new Text("", 0);
    int originalWidth;
    int originalHeight;
    int thumbnailWidth;
    int thumbnailHeight;

    public Thumbnail(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.setBorder(BorderFactory.createLoweredBevelBorder());
        this.setAlignmentX(0.5f);
        this.setAlignmentY(0.5f);
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public int getOriginalHeight() {
        return this.originalHeight;
    }

    public int getOriginalWidth() {
        return this.originalWidth;
    }

    public Dimension getPreferredSize() {
        Insets insets = this.getBorder().getBorderInsets(this);
        return new Dimension(this.width + insets.left + insets.right, this.height + insets.top + insets.bottom);
    }

    public void set(File file) {
        this.originalHeight = -1;
        this.originalWidth = -1;
        this.thumbnailHeight = -1;
        this.thumbnailWidth = -1;
        if (file != null && file.exists() && file.isFile()) {
            ImageIcon imageIcon = new ImageIcon(file.getAbsolutePath());
            if (imageIcon.getImageLoadStatus() == 8) {
                this.originalWidth = imageIcon.getIconWidth();
                this.originalHeight = imageIcon.getIconHeight();
                Image image = imageIcon.getImage();
                AreaAveragingScaleFilter areaAveragingScaleFilter = new AreaAveragingScaleFilter(200, 150);
                FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), areaAveragingScaleFilter);
                Image image2 = this.createImage(filteredImageSource);
                this.setIcon(new ImageIcon(image2));
                this.thumbnailWidth = this.getIcon().getIconWidth();
                this.thumbnailHeight = this.getIcon().getIconHeight();
            } else {
                this.setText("Error while loading.");
            }
        } else {
            this.setText("No image.");
        }
    }
}

