/*
 * Decompiled with CFR 0.152.
 */
package swing.addon;

import java.util.Enumeration;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class Tree
extends JScrollPane {
    private static final boolean DEBUG = false;
    public Object userData;
    JTree tree;
    DefaultMutableTreeNode rootNode;
    DefaultTreeModel treeModel;

    public Tree(String string) {
        this(new DefaultMutableTreeNode(string));
    }

    public Tree(DefaultTreeModel defaultTreeModel) {
        super(22, 30);
        this.tree = new JTree(defaultTreeModel);
        this.tree.setEditable(true);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setShowsRootHandles(true);
        this.tree.setAlignmentX(0.5f);
        this.tree.setAlignmentY(0.5f);
        this.rootNode = (DefaultMutableTreeNode)defaultTreeModel.getRoot();
        this.treeModel = defaultTreeModel;
        this.getViewport().setView(this.tree);
    }

    public Tree(TreeNode treeNode) {
        this(new DefaultTreeModel(treeNode));
    }

    public String[] add(String string) {
        int n = Tree.getChildPosition(this.rootNode, string);
        if (n == -1) {
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(string);
            this.rootNode.insert(defaultMutableTreeNode, this.rootNode.getChildCount());
            this.treeModel.reload();
        }
        return new String[]{string};
    }

    public void add(String[] stringArray, String[] stringArray2) {
        int n;
        DefaultMutableTreeNode defaultMutableTreeNode = this.rootNode;
        int n2 = 0;
        while (n2 < stringArray.length) {
            n = Tree.getChildPosition(defaultMutableTreeNode, stringArray[n2]);
            if (n == -1) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(stringArray[n2]);
                defaultMutableTreeNode.insert(defaultMutableTreeNode2, defaultMutableTreeNode.getChildCount());
                defaultMutableTreeNode = defaultMutableTreeNode2;
            } else {
                defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n);
            }
            ++n2;
        }
        n = 0;
        while (n < stringArray2.length) {
            defaultMutableTreeNode.insert(new DefaultMutableTreeNode(stringArray2[n]), n);
            ++n;
        }
        this.treeModel.reload();
    }

    public String[] add(String[] stringArray, String string) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.rootNode;
        int n = 0;
        while (n < stringArray.length) {
            int n2 = Tree.getChildPosition(defaultMutableTreeNode, stringArray[n]);
            if (n2 == -1) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(stringArray[n]);
                defaultMutableTreeNode.insert(defaultMutableTreeNode2, defaultMutableTreeNode.getChildCount());
                defaultMutableTreeNode = defaultMutableTreeNode2;
            } else {
                defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n2);
            }
            ++n;
        }
        defaultMutableTreeNode.insert(new DefaultMutableTreeNode(string), 0);
        this.treeModel.reload();
        String[] stringArray2 = new String[stringArray.length + 1];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        stringArray2[stringArray.length] = string;
        return stringArray2;
    }

    public String[] addSorted(String string) {
        int n = Tree.getChildPosition(this.rootNode, string);
        if (n == -1) {
            this.rootNode.insert(new DefaultMutableTreeNode(string), Tree.searchSortedPosition(this.rootNode, string));
            this.treeModel.reload();
        }
        return new String[]{string};
    }

    public String[] addSorted(String[] stringArray, String string) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.rootNode;
        int n = 0;
        while (n < stringArray.length) {
            int n2 = Tree.getChildPosition(defaultMutableTreeNode, stringArray[n]);
            if (n2 == -1) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(stringArray[n]);
                defaultMutableTreeNode.insert(defaultMutableTreeNode2, Tree.searchSortedPosition(defaultMutableTreeNode, stringArray[n]));
                defaultMutableTreeNode = defaultMutableTreeNode2;
            } else {
                defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n2);
            }
            ++n;
        }
        defaultMutableTreeNode.insert(new DefaultMutableTreeNode(string), Tree.searchSortedPosition(defaultMutableTreeNode, string));
        this.treeModel.reload();
        String[] stringArray2 = new String[stringArray.length + 1];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        stringArray2[stringArray.length] = string;
        return stringArray2;
    }

    public void addSorted(String[] stringArray, String[] stringArray2) {
        int n;
        DefaultMutableTreeNode defaultMutableTreeNode = this.rootNode;
        int n2 = 0;
        while (n2 < stringArray.length) {
            n = Tree.getChildPosition(defaultMutableTreeNode, stringArray[n2]);
            if (n == -1) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(stringArray[n2]);
                defaultMutableTreeNode.insert(defaultMutableTreeNode2, Tree.searchSortedPosition(defaultMutableTreeNode, stringArray[n2]));
                defaultMutableTreeNode = defaultMutableTreeNode2;
            } else {
                defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n);
            }
            ++n2;
        }
        n = 0;
        while (n < stringArray2.length) {
            defaultMutableTreeNode.insert(new DefaultMutableTreeNode(stringArray2[n]), Tree.searchSortedPosition(defaultMutableTreeNode, stringArray2[n]));
            ++n;
        }
        this.treeModel.reload();
    }

    public void addTreeSelectionListener(TreeSelectionListener treeSelectionListener) {
        this.tree.addTreeSelectionListener(treeSelectionListener);
    }

    public void clear() {
        this.rootNode.removeAllChildren();
        this.treeModel.reload();
    }

    private static int getChildPosition(DefaultMutableTreeNode defaultMutableTreeNode, String string) {
        int n = 0;
        if (defaultMutableTreeNode == null) {
            return -1;
        }
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
            if (((String)defaultMutableTreeNode2.getUserObject()).equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public String getSelectedItem() {
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath == null) {
            return null;
        }
        Object[] objectArray = treePath.getPath();
        if (!((DefaultMutableTreeNode)objectArray[objectArray.length - 1]).isLeaf()) {
            return null;
        }
        return (String)((DefaultMutableTreeNode)objectArray[objectArray.length - 1]).getUserObject();
    }

    public String getSelectedItemWithFullPath(char c) {
        StringBuffer stringBuffer = new StringBuffer(100);
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath == null) {
            return null;
        }
        Object[] objectArray = treePath.getPath();
        if (!((DefaultMutableTreeNode)objectArray[objectArray.length - 1]).isLeaf()) {
            return null;
        }
        int n = 1;
        while (n < objectArray.length) {
            stringBuffer.append((String)((DefaultMutableTreeNode)objectArray[n]).getUserObject());
            if (n + 1 < objectArray.length) {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private static int searchSortedPosition(DefaultMutableTreeNode defaultMutableTreeNode, String string) {
        int n = defaultMutableTreeNode.getChildCount();
        int n2 = 0;
        n2 = 0;
        while (n2 < n) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n2);
            if (((String)defaultMutableTreeNode2.getUserObject()).compareTo(string) > 0) break;
            ++n2;
        }
        return n2;
    }

    public void setEditable(boolean bl) {
        this.tree.setEditable(bl);
    }

    public void setRootVisible(boolean bl) {
        this.tree.setRootVisible(bl);
    }

    public void setSelectionInterval(int n, int n2) {
        this.tree.setSelectionInterval(n, n2);
    }

    public void setShowsRootHandles(boolean bl) {
        this.tree.setShowsRootHandles(bl);
    }
}

