/*
 * Decompiled with CFR 0.152.
 */
package swing.addon;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import jreqtools.JReqTools;
import swing.addon.Frame;
import swing.addon.GUISystem;
import swing.addon.MenuItem;
import swing.addon.PopupMenu;
import swing.addon.Prefs;
import swing.addon.util.FileAccess;

public final class Utils {
    private static final boolean DEBUG = false;
    private static Frame invisibleFrame = new Frame("");
    private static Hashtable iconBuffer = new Hashtable(10, 10.0f);

    private Utils() {
    }

    public static void addMenuItemsFrom(String[] stringArray, String string, String string2, PopupMenu popupMenu, ActionListener actionListener) {
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        int n = 0;
        while (n < stringArray.length) {
            MenuItem menuItem = popupMenu.add(new MenuItem(string + stringArray[n] + string2));
            menuItem.setActionCommand(stringArray[n]);
            menuItem.addActionListener(actionListener);
            ++n;
        }
    }

    public static void addMenuItemsFromFile(String string, String string2, String string3, PopupMenu popupMenu, ActionListener actionListener) {
        if (string2 == null) {
            string2 = "";
        }
        if (string3 == null) {
            string3 = "";
        }
        try {
            String string4;
            FileAccess fileAccess = new FileAccess(string);
            while ((string4 = fileAccess.readLine()) != null) {
                MenuItem menuItem = popupMenu.add(new MenuItem(string2 + string4 + string3));
                menuItem.setActionCommand(string4);
                menuItem.addActionListener(actionListener);
            }
        }
        catch (IOException iOException) {
            JReqTools.showException(iOException);
        }
    }

    public static void centerOn(Frame frame, Window window) {
        Dimension dimension = frame.getSize();
        Dimension dimension2 = window.getSize();
        Point point = frame.getLocationOnScreen();
        point.x += (dimension.width - dimension2.width) / 2;
        if (point.x < 0) {
            point.x = 0;
        }
        point.y += (dimension.height - dimension2.height) / 2;
        if (point.y < 0) {
            point.y = 0;
        }
        ((Component)window).setLocation(point);
    }

    public static final MouseListener createMouseListenerForPopupMenu(final JComponent jComponent, final JPopupMenu jPopupMenu) {
        if (Prefs.isWindowsSystem()) {
            return new MouseAdapter(){

                public void mouseReleased(MouseEvent mouseEvent) {
                    if (mouseEvent.isPopupTrigger()) {
                        jPopupMenu.show(jComponent, mouseEvent.getX() - 5, mouseEvent.getY() - 5);
                        mouseEvent.consume();
                    }
                }
            };
        }
        return new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    jPopupMenu.show(jComponent, mouseEvent.getX(), mouseEvent.getY());
                    mouseEvent.consume();
                }
            }
        };
    }

    public static final PopupMenu createPopupMenu(JComponent jComponent, String string) {
        PopupMenu popupMenu = new PopupMenu(string);
        jComponent.add(popupMenu);
        jComponent.addMouseListener(Utils.createMouseListenerForPopupMenu(jComponent, popupMenu));
        return popupMenu;
    }

    public static Frame getFrame(Component component) {
        Container container = component.getParent();
        while (!(container instanceof Frame)) {
            container = container.getParent();
        }
        return (Frame)container;
    }

    public static ImageIcon getImageIconFromJarFile(String string, String string2) {
        ImageIcon imageIcon = null;
        try {
            ZipFile zipFile = new ZipFile(string);
            ZipEntry zipEntry = zipFile.getEntry(string2);
            InputStream inputStream = zipFile.getInputStream(zipEntry);
            int n = (int)zipEntry.getSize();
            byte[] byArray = new byte[n];
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            dataInputStream.readFully(byArray);
            imageIcon = new ImageIcon(byArray);
            dataInputStream.close();
            zipFile.close();
        }
        catch (Throwable throwable) {
            GUISystem.err.println(throwable);
        }
        return imageIcon;
    }

    public static final String makeFileURL(String string) {
        String string2 = string;
        if (File.separatorChar == '\\') {
            string2 = string2.replace('\\', '/');
            string2 = "file://localhost/" + string2;
        } else {
            string2 = "file://" + string2;
        }
        return string2;
    }

    public static void setBusy(Container container, boolean bl) {
        Vector<Component> vector = new Vector<Component>(10);
        vector.addElement(container);
        Cursor cursor = Prefs.getWaitCursor();
        Cursor cursor2 = Prefs.getNormalCursor();
        while (vector.size() > 0) {
            Container container2 = (Container)vector.elementAt(0);
            vector.removeElementAt(0);
            int n = container2.getComponentCount();
            int n2 = 0;
            while (n2 < n) {
                Component component = container2.getComponent(n2);
                if (component instanceof Container) {
                    vector.addElement(component);
                }
                component.setCursor(bl ? cursor : cursor2);
                ++n2;
            }
        }
    }
}

