/*
 * Decompiled with CFR 0.152.
 */
package swing.addon.plaf.threeD;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import swing.addon.plaf.threeD.Strut;
import swing.addon.plaf.threeD.ThreeDUtils;

final class JBorderChooser
extends JDialog {
    int type = -1;
    int init = -1;
    boolean SELECTED = false;
    JToggleButton[] toggle = new JToggleButton[12];
    JButton ok = new JButton("OK");
    JButton reset = new JButton("Reset");
    JButton cancel = new JButton("Cancel");

    public JBorderChooser() {
        this.setModal(true);
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(this.createBorderPanel());
        jPanel.add(new Strut());
        jPanel.add(new JPopupMenu.Separator());
        jPanel.add(new Strut());
        jPanel.add(this.createButtons());
        this.pack();
        Dimension dimension = this.getSize();
        if (dimension.width < 300) {
            dimension.width = 300;
        }
        if (dimension.height < 300) {
            dimension.height = 300;
        }
        ((Component)this).setSize(dimension);
    }

    private void cancel() {
        ((Component)this).setVisible(false);
    }

    private JPanel createBorderPanel() {
        JPanel jPanel = new JPanel(new GridLayout(0, 6, 4, 4));
        ButtonGroup buttonGroup = new ButtonGroup();
        int n = 0;
        while (n < 12) {
            this.toggle[n] = this.makeToggleButton(n);
            jPanel.add(this.toggle[n]);
            buttonGroup.add(this.toggle[n]);
            ++n;
        }
        return jPanel;
    }

    private Box createButtons() {
        Box box = Box.createHorizontalBox();
        box.add(this.ok);
        box.add(new Strut());
        box.add(Box.createHorizontalGlue());
        box.add(this.reset);
        box.add(Box.createHorizontalGlue());
        box.add(new Strut());
        box.add(this.cancel);
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JBorderChooser.this.ok();
            }
        });
        this.reset.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JBorderChooser.this.reset();
            }
        });
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JBorderChooser.this.cancel();
            }
        });
        return box;
    }

    private JToggleButton makeToggleButton(final int n) {
        JToggleButton jToggleButton = new JToggleButton();
        jToggleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JBorderChooser.this.type = n;
            }
        });
        jToggleButton.setIcon(new Icon(){
            private int w = 100;
            private int h = 50;

            public int getIconWidth() {
                return this.w;
            }

            public int getIconHeight() {
                return this.h;
            }

            public void paintIcon(Component component, Graphics graphics, int n3, int n2) {
                ThreeDUtils.drawBorder(n, graphics, n3, n2, this.w, this.h);
            }
        });
        return jToggleButton;
    }

    private void ok() {
        this.SELECTED = true;
        ((Component)this).setVisible(false);
    }

    private void reset() {
        this.toggle[this.init].setSelected(true);
    }

    public int showDialog(JComponent jComponent, String string, int n) {
        this.setTitle(string);
        this.init = this.type = n;
        this.reset();
        this.SELECTED = false;
        ((Component)this).setLocation(jComponent.getLocationOnScreen());
        ((Component)this).setVisible(true);
        return this.SELECTED ? this.type : -1;
    }
}

