/*
 * Decompiled with CFR 0.152.
 */
package swing.addon.plaf.threeD;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import swing.addon.plaf.threeD.JFontShower;
import swing.addon.plaf.threeD.Strut;

final class JFontChooser
extends JDialog {
    Font userfont = new Font("SansSerif", 0, 12);
    boolean SELECTED = false;
    GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
    JList names = new JList<String>(this.env.getAvailableFontFamilyNames());
    JList size = new JList<String>(new String[]{"6", "8", "10", "12", "14", "16", "18", "20", "24", "36", "48"});
    JTextField entersize = new JTextField(""){

        public Dimension getMaximumSize() {
            return new Dimension(Short.MAX_VALUE, this.getPreferredSize().height);
        }
    };
    JFontShower fontshower = new JFontShower();
    JButton ok = new JButton("OK");
    JButton reset = new JButton("Reset");
    JButton cancel = new JButton("Cancel");

    public JFontChooser() {
        this.setModal(true);
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(this.createFontPanel());
        jPanel.add(new Strut());
        jPanel.add(new JPopupMenu.Separator());
        jPanel.add(new Strut());
        jPanel.add(this.createButtons());
        this.pack();
        Dimension dimension = this.getSize();
        if (dimension.width < 300) {
            dimension.width = 300;
        }
        if (dimension.height < 300) {
            dimension.height = 300;
        }
        ((Component)this).setSize(dimension);
    }

    private void cancel() {
        ((Component)this).setVisible(false);
    }

    private void checkSize() {
        try {
            int n = Integer.parseInt(this.entersize.getText());
            if (n < 6) {
                this.getToolkit().beep();
                this.entersize.setText("6");
                return;
            }
            if (n > 200) {
                this.getToolkit().beep();
                this.entersize.setText("200");
                return;
            }
        }
        catch (Exception exception) {
            this.getToolkit().beep();
            this.entersize.setText("12");
            return;
        }
    }

    private Box createButtons() {
        Box box = Box.createHorizontalBox();
        box.add(this.ok);
        box.add(new Strut());
        box.add(Box.createHorizontalGlue());
        box.add(this.reset);
        box.add(Box.createHorizontalGlue());
        box.add(new Strut());
        box.add(this.cancel);
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFontChooser.this.ok();
            }
        });
        this.reset.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFontChooser.this.reset();
            }
        });
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFontChooser.this.cancel();
            }
        });
        return box;
    }

    private Font createFont() {
        this.checkSize();
        return new Font((String)this.names.getSelectedValue(), 0, Math.abs(Integer.parseInt(this.entersize.getText())));
    }

    private JPanel createFontPanel() {
        this.size.setSelectionMode(0);
        this.entersize.setColumns(3);
        this.names.setSelectionMode(0);
        this.reset();
        this.size.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                JFontChooser.this.entersize.setText((String)JFontChooser.this.size.getSelectedValue());
                JFontChooser.this.fontshower.setFont(JFontChooser.this.createFont());
            }
        });
        this.names.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                JFontChooser.this.fontshower.setFont(JFontChooser.this.createFont());
            }
        });
        this.entersize.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFontChooser.this.size.setSelectedValue(JFontChooser.this.entersize.getText(), true);
                JFontChooser.this.fontshower.setFont(JFontChooser.this.createFont());
            }
        });
        Box box = Box.createVerticalBox();
        box.add(new JScrollPane(this.size, 22, 30));
        box.add(this.entersize);
        Box box2 = Box.createHorizontalBox();
        box2.add(new JScrollPane(this.names, 22, 30));
        box2.add(new Strut());
        box2.add(box);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(box2);
        jPanel.add(new Strut());
        jPanel.add(this.fontshower);
        return jPanel;
    }

    private void ok() {
        this.SELECTED = true;
        this.userfont = this.createFont();
        ((Component)this).setVisible(false);
    }

    private void reset() {
        this.size.setSelectedValue("" + this.userfont.getSize(), true);
        this.entersize.setText("" + this.userfont.getSize());
        this.names.setSelectedValue(this.userfont.getName(), true);
        this.fontshower.setFont(this.userfont);
    }

    public Font showDialog(JComponent jComponent, String string, Font font) {
        this.setTitle(string);
        this.userfont = font;
        this.reset();
        this.SELECTED = false;
        ((Component)this).setLocation(jComponent.getLocationOnScreen());
        ((Component)this).setVisible(true);
        return this.SELECTED ? this.userfont : null;
    }
}

