/*
 * Decompiled with CFR 0.152.
 */
package swing.addon.plaf.threeD;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JInternalFrame;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.UIResource;
import javax.swing.text.JTextComponent;
import swing.addon.plaf.threeD.ThreeDPrefs;
import swing.addon.plaf.threeD.ThreeDUtils;
import swing.addon.plaf.threeD.ThreeD_ComboBoxPopup;

class ThreeDBorders {
    ThreeDBorders() {
    }

    static final class ToolBarBorder
    extends AbstractBorder
    implements UIResource {
        ToolBarBorder() {
        }

        public Insets getBorderInsets(Component component) {
            Insets insets;
            JToolBar jToolBar = (JToolBar)component;
            Insets insets2 = new Insets(4, 4, 4, 4);
            if (jToolBar.isFloatable()) {
                if (jToolBar.getOrientation() == 0) {
                    insets2.left = 16;
                } else {
                    insets2.top = 16;
                }
            }
            if ((insets = jToolBar.getMargin()) != null) {
                insets2.left += insets.left;
                insets2.top += insets.top;
                insets2.right += insets.right;
                insets2.bottom += insets.bottom;
            }
            return insets2;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            JToolBar jToolBar = (JToolBar)component;
            Dimension dimension = jToolBar.getSize();
            Insets insets = jToolBar.getInsets();
            graphics.translate(n, n2);
            if (jToolBar.isFloatable()) {
                if (jToolBar.getOrientation() == 0) {
                    graphics.setColor(ThreeDPrefs.highlightColor);
                    graphics.fillRect(3, 3, 8, dimension.height - 5);
                    ThreeDUtils.drawBorder(graphics, 2, 2, 10, dimension.height - 4, ThreeDPrefs.lightEdgeColor, ThreeDPrefs.darkEdgeColor);
                } else {
                    graphics.setColor(ThreeDPrefs.highlightColor);
                    graphics.fillRect(3, 3, dimension.width - 5, 8);
                    ThreeDUtils.drawBorder(graphics, 2, 2, dimension.width - 4, 10, ThreeDPrefs.lightEdgeColor, ThreeDPrefs.darkEdgeColor);
                }
            }
            graphics.translate(-n, -n2);
        }
    }

    static final class ToggleButtonBorder
    extends AbstractBorder
    implements UIResource {
        ToggleButtonBorder() {
        }

        public Insets getBorderInsets(Component component) {
            Insets insets = ThreeDUtils.getBorderInsets(ThreeDPrefs.toggleButtonBorderType1);
            Insets insets2 = ThreeDUtils.getBorderInsets(ThreeDPrefs.toggleButtonBorderType2);
            return insets.left > insets2.left ? insets : insets2;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            JToggleButton jToggleButton = (JToggleButton)component;
            ButtonModel buttonModel = jToggleButton.getModel();
            if (buttonModel.isPressed() || buttonModel.isSelected()) {
                ThreeDUtils.drawBorder(ThreeDPrefs.toggleButtonBorderType2, graphics, n, n2, n3, n4);
            } else {
                ThreeDUtils.drawBorder(ThreeDPrefs.toggleButtonBorderType1, graphics, n, n2, n3, n4);
            }
        }
    }

    static final class TitledBorder
    extends AbstractBorder
    implements UIResource {
        TitledBorder() {
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(2, 2, 2, 2);
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.setColor(ThreeDPrefs.darkEdgeColor);
            graphics.drawRect(n, n2, n3 - 2, n4 - 2);
            graphics.setColor(ThreeDPrefs.lightEdgeColor);
            graphics.drawRect(n + 1, n2 + 1, n3 - 2, n4 - 2);
        }
    }

    static final class TextComponentBorder
    extends AbstractBorder
    implements UIResource {
        TextComponentBorder() {
        }

        public Insets getBorderInsets(Component component) {
            if (component.getParent() instanceof JViewport) {
                return new Insets(0, 0, 0, 0);
            }
            return ((JTextComponent)component).isEditable() ? ThreeDUtils.getBorderInsets(ThreeDPrefs.textComponentBorderType1) : ThreeDUtils.getBorderInsets(ThreeDPrefs.textComponentBorderType2);
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            if (component.getParent() instanceof JViewport) {
                return;
            }
            JTextComponent jTextComponent = (JTextComponent)component;
            if (jTextComponent.getParent() instanceof JViewport) {
                Rectangle rectangle = ((JViewport)jTextComponent.getParent()).getViewRect();
                n = rectangle.x;
                n2 = rectangle.y;
                n3 = rectangle.width;
                n4 = rectangle.height;
            }
            if (jTextComponent.isEditable()) {
                ThreeDUtils.drawBorder(ThreeDPrefs.textComponentBorderType1, graphics, n, n2, n3, n4);
            } else {
                ThreeDUtils.drawBorder(ThreeDPrefs.textComponentBorderType2, graphics, n, n2, n3, n4);
            }
        }
    }

    static final class TableHeaderBorder
    extends AbstractBorder
    implements UIResource {
        TableHeaderBorder() {
        }

        public Insets getBorderInsets(Component component) {
            Insets insets = ThreeDUtils.getBorderInsets(ThreeDPrefs.tableHeaderBorderType);
            return new Insets(insets.top + 1, insets.left + 1, insets.bottom + 1, insets.right + 1);
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            ThreeDUtils.drawBorder(ThreeDPrefs.tableHeaderBorderType, graphics, n, n2, n3, n4);
        }
    }

    static final class TableBorder
    extends AbstractBorder
    implements UIResource {
        TableBorder() {
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(2, 2, 2, 2);
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        }
    }

    static final class SplitPaneBorder
    extends AbstractBorder
    implements UIResource {
        SplitPaneBorder() {
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(0, 0, 0, 0);
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        }
    }

    static final class ScrollPaneViewportBorder
    extends AbstractBorder
    implements UIResource {
        ScrollPaneViewportBorder() {
        }

        public Insets getBorderInsets(Component component) {
            Component component2 = ((JScrollPane)component).getViewport().getView();
            if (component2 != null && component2 instanceof JTree) {
                Insets insets = ThreeDUtils.getBorderInsets(ThreeDPrefs.treeBorderType);
                return new Insets(insets.top + 1, insets.left + 1, insets.bottom + 1, insets.right + 1);
            }
            if (component2 != null && component2 instanceof JTable) {
                Insets insets = ThreeDUtils.getBorderInsets(ThreeDPrefs.tableBorderType);
                return new Insets(insets.top + 1, insets.left + 1, insets.bottom + 1, insets.right + 1);
            }
            if (component2 != null && component2 instanceof JList) {
                Insets insets = ThreeDUtils.getBorderInsets(ThreeDPrefs.listBorderType);
                return new Insets(insets.top + 1, insets.left + 1, insets.bottom + 1, insets.right + 1);
            }
            if (component2 != null && (component2 instanceof JEditorPane || component2 instanceof JTextArea)) {
                Insets insets = ThreeDUtils.getBorderInsets(ThreeDPrefs.textComponentBorderType1);
                if (!((JTextComponent)component2).isEditable()) {
                    insets = ThreeDUtils.getBorderInsets(ThreeDPrefs.textComponentBorderType2);
                }
                return new Insets(insets.top + 1, insets.left + 1, insets.bottom + 1, insets.right + 1);
            }
            return new Insets(0, 0, 0, 0);
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Component component2 = ((JScrollPane)component).getViewport().getView();
            if (component2 != null && component2 instanceof JTree) {
                ThreeDUtils.drawBorder(ThreeDPrefs.treeBorderType, graphics, n, n2, n3, n4);
            } else if (component2 != null && component2 instanceof JTable) {
                ThreeDUtils.drawBorder(ThreeDPrefs.tableBorderType, graphics, n, n2, n3, n4);
            } else if (component2 != null && component2 instanceof JList) {
                ThreeDUtils.drawBorder(ThreeDPrefs.listBorderType, graphics, n, n2, n3, n4);
            } else if (component2 != null && (component2 instanceof JEditorPane || component2 instanceof JTextArea)) {
                JTextComponent jTextComponent = (JTextComponent)component2;
                if (jTextComponent.isEditable()) {
                    ThreeDUtils.drawBorder(ThreeDPrefs.textComponentBorderType1, graphics, n, n2, n3, n4);
                } else {
                    ThreeDUtils.drawBorder(ThreeDPrefs.textComponentBorderType2, graphics, n, n2, n3, n4);
                }
            }
        }
    }

    static final class ScrollPaneBorder
    extends AbstractBorder
    implements UIResource {
        ScrollPaneBorder() {
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(0, 0, 0, 0);
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        }
    }

    static final class ProgressBarBorder
    extends AbstractBorder
    implements UIResource {
        ProgressBarBorder() {
        }

        public Insets getBorderInsets(Component component) {
            return ThreeDUtils.getBorderInsets(ThreeDPrefs.progressBarBorderType);
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            ThreeDUtils.drawBorder(ThreeDPrefs.progressBarBorderType, graphics, n, n2, n3, n4);
        }
    }

    static final class PopupMenuBorder
    extends AbstractBorder
    implements UIResource {
        PopupMenuBorder() {
        }

        public Insets getBorderInsets(Component component) {
            if (component instanceof ThreeD_ComboBoxPopup) {
                return new Insets(0, 0, 0, 0);
            }
            Insets insets = ThreeDUtils.getBorderInsets(ThreeDPrefs.popupMenuBorderType);
            return new Insets(insets.top + 1, insets.left + 1, insets.bottom + 1, insets.right + 1);
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            if (component instanceof ThreeD_ComboBoxPopup) {
                return;
            }
            ThreeDUtils.drawBorder(ThreeDPrefs.popupMenuBorderType, graphics, n, n2, n3, n4);
        }
    }

    static final class MenuItemBorder
    extends AbstractBorder
    implements UIResource {
        MenuItemBorder() {
        }

        public Insets getBorderInsets(Component component) {
            return ThreeDUtils.getBorderInsets(ThreeDPrefs.menuItemBorderType);
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            JMenuItem jMenuItem = (JMenuItem)component;
            ButtonModel buttonModel = jMenuItem.getModel();
            if (buttonModel.isArmed()) {
                ThreeDUtils.drawBorder(ThreeDPrefs.menuItemBorderType, graphics, n, n2, n3, n4);
            }
        }
    }

    static final class MenuBorder
    extends AbstractBorder
    implements UIResource {
        MenuBorder() {
        }

        public Insets getBorderInsets(Component component) {
            Insets insets = ThreeDUtils.getBorderInsets(ThreeDPrefs.menuBorderType);
            return new Insets(insets.top + 1, insets.left + 1, insets.bottom + 1, insets.right + 1);
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            JMenu jMenu = (JMenu)component;
            ButtonModel buttonModel = jMenu.getModel();
            if (buttonModel.isSelected()) {
                if (jMenu.getParent() instanceof JMenuBar) {
                    int n5 = ThreeDUtils.isLoweredBorderType(ThreeDPrefs.menuBorderType) ? 10 : 0;
                    ThreeDUtils.drawBorder(ThreeDPrefs.menuBorderType, graphics, n, n2, n3, n4 + n5);
                } else {
                    int n6 = ThreeDUtils.isLoweredBorderType(ThreeDPrefs.menuBorderType) ? 10 : 0;
                    ThreeDUtils.drawBorder(ThreeDPrefs.menuBorderType, graphics, n, n2, n3 + n6, n4);
                }
            }
        }
    }

    static final class MenuBarBorder
    extends AbstractBorder
    implements UIResource {
        MenuBarBorder() {
        }

        public Insets getBorderInsets(Component component) {
            Insets insets = ThreeDUtils.getBorderInsets(ThreeDPrefs.menuBarBorderType);
            return new Insets(insets.top + 1, insets.left + 1, insets.bottom + 1, insets.right + 1);
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            ThreeDUtils.drawBorder(ThreeDPrefs.menuBarBorderType, graphics, n, n2, n3, n4);
        }
    }

    static final class ListFocusCellHighlightBorder
    extends AbstractBorder
    implements UIResource {
        ListFocusCellHighlightBorder() {
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(1, 1, 1, 1);
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.setColor(ThreeDPrefs.focusColor);
            graphics.drawRect(n, n2, n3 - 1, n4 - 1);
        }
    }

    static final class ListBorder
    extends AbstractBorder
    implements UIResource {
        ListBorder() {
        }

        public Insets getBorderInsets(Component component) {
            if (component.getParent() instanceof JViewport) {
                return new Insets(0, 0, 0, 0);
            }
            return ThreeDUtils.getBorderInsets(ThreeDPrefs.listBorderType);
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            if (component.getParent() instanceof JViewport) {
                return;
            }
            ThreeDUtils.drawBorder(ThreeDPrefs.listBorderType, graphics, n, n2, n3, n4);
        }
    }

    static final class InternalFrameBorder
    extends AbstractBorder {
        static final int SIZER = 15;

        InternalFrameBorder() {
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(4, 4, 4, 4);
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.translate(n, n2);
            if (((JInternalFrame)component).isSelected()) {
                graphics.setColor(ThreeDPrefs.highlightColor);
                graphics.fillRect(0, 0, n3, 4);
                graphics.fillRect(0, 0, 4, n4);
                graphics.fillRect(n3 - 5, 0, 4, n4);
                graphics.fillRect(0, n4 - 5, n3, 4);
            }
            ThreeDUtils.drawBorder(2, graphics, 0, 0, n3, n4);
            ThreeDUtils.drawBorder(3, graphics, 3, 3, n3 - 6, n4 - 6);
            if (((JInternalFrame)component).isResizable()) {
                graphics.setColor(ThreeDPrefs.darkEdgeColor);
                graphics.drawLine(15, 0, 15, 3);
                graphics.drawLine(n3 - 1 - 15, 0, n3 - 1 - 15, 3);
                graphics.setColor(ThreeDPrefs.lightEdgeColor);
                graphics.drawLine(16, 0, 16, 3);
                graphics.drawLine(n3 - 15, 0, n3 - 15, 3);
                graphics.setColor(ThreeDPrefs.darkEdgeColor);
                graphics.drawLine(15, n4 - 1, 15, n4 - 4);
                graphics.drawLine(n3 - 1 - 15, n4 - 1, n3 - 1 - 15, n4 - 4);
                graphics.setColor(ThreeDPrefs.lightEdgeColor);
                graphics.drawLine(16, n4 - 1, 16, n4 - 4);
                graphics.drawLine(n3 - 15, n4 - 1, n3 - 15, n4 - 4);
                graphics.setColor(ThreeDPrefs.darkEdgeColor);
                graphics.drawLine(0, 15, 3, 15);
                graphics.drawLine(0, n4 - 1 - 15, 3, n4 - 1 - 15);
                graphics.setColor(ThreeDPrefs.lightEdgeColor);
                graphics.drawLine(0, 16, 3, 16);
                graphics.drawLine(0, n4 - 15, 3, n4 - 15);
                graphics.setColor(ThreeDPrefs.darkEdgeColor);
                graphics.drawLine(n3 - 1, 15, n3 - 4, 15);
                graphics.drawLine(n3 - 1, n4 - 1 - 15, n3 - 4, n4 - 1 - 15);
                graphics.setColor(ThreeDPrefs.lightEdgeColor);
                graphics.drawLine(n3 - 1, 16, n3 - 4, 16);
                graphics.drawLine(n3 - 1, n4 - 15, n3 - 4, n4 - 15);
            }
            graphics.translate(-n, -n2);
        }
    }

    static final class DesktopIconBorder
    extends AbstractBorder
    implements UIResource {
        DesktopIconBorder() {
        }

        public Insets getBorderInsets(Component component) {
            return ThreeDUtils.getBorderInsets(ThreeDPrefs.buttonBorderType1);
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            ThreeDUtils.drawBorder(ThreeDPrefs.buttonBorderType1, graphics, n, n2, n3, n4);
        }
    }

    static final class ComboBoxPopupBorder
    extends AbstractBorder
    implements UIResource {
        ComboBoxPopupBorder() {
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(0, 0, 0, 0);
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        }
    }

    static final class ComboBoxBorder
    extends AbstractBorder
    implements UIResource {
        ComboBoxBorder() {
        }

        public Insets getBorderInsets(Component component) {
            return ThreeDUtils.getBorderInsets(ThreeDPrefs.comboBoxBorderType);
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            if (((JComboBox)component).isEditable()) {
                return;
            }
            ThreeDUtils.drawBorder(ThreeDPrefs.comboBoxBorderType, graphics, n, n2, n3, n4);
        }
    }

    static final class ButtonBorder
    extends AbstractBorder
    implements UIResource {
        ButtonBorder() {
        }

        public Insets getBorderInsets(Component component) {
            Insets insets = ThreeDUtils.getBorderInsets(ThreeDPrefs.buttonBorderType1);
            Insets insets2 = ThreeDUtils.getBorderInsets(ThreeDPrefs.buttonBorderType2);
            return insets.left > insets2.left ? insets : insets2;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            JButton jButton = (JButton)component;
            ButtonModel buttonModel = jButton.getModel();
            if (buttonModel.isPressed()) {
                ThreeDUtils.drawBorder(ThreeDPrefs.buttonBorderType2, graphics, n, n2, n3, n4);
            } else {
                ThreeDUtils.drawBorder(ThreeDPrefs.buttonBorderType1, graphics, n, n2, n3, n4);
            }
        }
    }
}

