/*
 * Decompiled with CFR 0.152.
 */
package swing.addon.plaf.threeD;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Polygon;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.plaf.UIResource;
import swing.addon.plaf.threeD.ThreeDPrefs;
import swing.addon.plaf.threeD.ThreeDUtils;

class ThreeDIcons {
    public static final int RIGHT = 0;
    public static final int LEFT = 1;
    public static final int UP = 2;
    public static final int DOWN = 3;

    ThreeDIcons() {
    }

    static final class RadioButtonMenuIcon
    implements Icon,
    UIResource {
        static final int SIZE = 13;

        RadioButtonMenuIcon() {
        }

        public int getIconHeight() {
            Insets insets = ThreeDUtils.getBorderInsets(ThreeDPrefs.radioButtonBorderType1);
            return 13 + insets.top + insets.bottom;
        }

        public int getIconWidth() {
            Insets insets = ThreeDUtils.getBorderInsets(ThreeDPrefs.radioButtonBorderType1);
            return 13 + insets.left + insets.right;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            JRadioButtonMenuItem jRadioButtonMenuItem = (JRadioButtonMenuItem)component;
            ButtonModel buttonModel = jRadioButtonMenuItem.getModel();
            if (buttonModel.isPressed() || buttonModel.isSelected()) {
                graphics.setColor(ThreeDPrefs.highlightColor);
                graphics.fillRect(n, n2, this.getIconWidth() - 1, this.getIconHeight() - 1);
                ThreeDUtils.drawBorder(ThreeDPrefs.radioButtonBorderType2, graphics, n, n2, this.getIconWidth(), this.getIconHeight());
            } else {
                ThreeDUtils.drawBorder(ThreeDPrefs.radioButtonBorderType1, graphics, n, n2, this.getIconWidth(), this.getIconHeight());
            }
        }
    }

    static final class RadioButtonIcon
    implements Icon,
    UIResource {
        static final int SIZE = 13;

        RadioButtonIcon() {
        }

        public int getIconHeight() {
            Insets insets = ThreeDUtils.getBorderInsets(ThreeDPrefs.radioButtonBorderType1);
            return 13 + insets.top + insets.bottom;
        }

        public int getIconWidth() {
            Insets insets = ThreeDUtils.getBorderInsets(ThreeDPrefs.radioButtonBorderType1);
            return 13 + insets.left + insets.right;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            JRadioButton jRadioButton = (JRadioButton)component;
            ButtonModel buttonModel = jRadioButton.getModel();
            if (buttonModel.isPressed() || buttonModel.isSelected()) {
                graphics.setColor(ThreeDPrefs.highlightColor);
                graphics.fillRect(n, n2, this.getIconWidth() - 1, this.getIconHeight() - 1);
                ThreeDUtils.drawBorder(ThreeDPrefs.radioButtonBorderType2, graphics, n, n2, this.getIconWidth(), this.getIconHeight());
            } else {
                ThreeDUtils.drawBorder(ThreeDPrefs.radioButtonBorderType1, graphics, n, n2, this.getIconWidth(), this.getIconHeight());
            }
        }
    }

    static final class InternalFrameIcon3
    implements Icon,
    UIResource {
        final int SIZE = 9;

        InternalFrameIcon3() {
        }

        public int getIconHeight() {
            return 13;
        }

        public int getIconWidth() {
            return 13;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.translate(n + 2, n2 + 2);
            graphics.setColor(ThreeDPrefs.textColor);
            graphics.drawRect(0, 0, 8, 8);
            graphics.drawRect(0, 4, 4, 4);
            graphics.setColor(ThreeDPrefs.lightEdgeColor);
            graphics.fillRect(1, 5, 2, 2);
            graphics.translate(-n - 2, -n2 - 2);
        }
    }

    static final class InternalFrameIcon2
    implements Icon,
    UIResource {
        final int SIZE = 9;

        InternalFrameIcon2() {
        }

        public int getIconHeight() {
            return 13;
        }

        public int getIconWidth() {
            return 13;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.translate(n + 2, n2 + 2);
            graphics.setColor(ThreeDPrefs.textColor);
            graphics.drawLine(3, 4, 5, 4);
            graphics.drawLine(4, 3, 4, 5);
            graphics.translate(-n - 2, -n2 - 2);
        }
    }

    static final class InternalFrameIcon1
    implements Icon,
    UIResource {
        final int SIZE = 9;

        InternalFrameIcon1() {
        }

        public int getIconHeight() {
            return 13;
        }

        public int getIconWidth() {
            return 13;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.translate(n + 2, n2 + 2);
            graphics.setColor(ThreeDPrefs.textColor);
            graphics.drawLine(0, 0, 8, 8);
            graphics.drawLine(8, 0, 0, 8);
            graphics.translate(-n - 2, -n2 - 2);
        }
    }

    static final class CheckBoxMenuIcon
    implements Icon,
    UIResource {
        private static final int SIZE = 13;

        CheckBoxMenuIcon() {
        }

        public int getIconHeight() {
            Insets insets = ThreeDUtils.getBorderInsets(ThreeDPrefs.checkBoxBorderType1);
            return 13 + insets.top + insets.bottom;
        }

        public int getIconWidth() {
            Insets insets = ThreeDUtils.getBorderInsets(ThreeDPrefs.checkBoxBorderType1);
            return 13 + insets.left + insets.right;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)component;
            ButtonModel buttonModel = jCheckBoxMenuItem.getModel();
            if (buttonModel.isPressed()) {
                graphics.setColor(ThreeDPrefs.highlightColor);
                graphics.fillRect(n, n2, this.getIconWidth() - 1, this.getIconHeight() - 1);
                ThreeDUtils.drawBorder(ThreeDPrefs.checkBoxBorderType2, graphics, n, n2, this.getIconWidth(), this.getIconHeight());
            } else {
                ThreeDUtils.drawBorder(ThreeDPrefs.checkBoxBorderType1, graphics, n, n2, this.getIconWidth(), this.getIconHeight());
            }
            if (buttonModel.isSelected()) {
                Insets insets = ThreeDUtils.getBorderInsets(ThreeDPrefs.checkBoxBorderType1);
                graphics.setColor(ThreeDPrefs.textColor);
                graphics.fillRect((n += insets.left) + 3, (n2 += insets.top) + 5, 2, 5);
                graphics.drawLine(n + 9, n2 + 3, n + 5, n2 + 7);
                graphics.drawLine(n + 9, n2 + 4, n + 5, n2 + 8);
            }
        }
    }

    static final class CheckBoxIcon
    implements Icon,
    UIResource {
        private static final int SIZE = 13;

        CheckBoxIcon() {
        }

        public int getIconHeight() {
            Insets insets = ThreeDUtils.getBorderInsets(ThreeDPrefs.checkBoxBorderType1);
            return 13 + insets.top + insets.bottom;
        }

        public int getIconWidth() {
            Insets insets = ThreeDUtils.getBorderInsets(ThreeDPrefs.checkBoxBorderType1);
            return 13 + insets.left + insets.right;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            JCheckBox jCheckBox = (JCheckBox)component;
            ButtonModel buttonModel = jCheckBox.getModel();
            if (buttonModel.isPressed()) {
                graphics.setColor(ThreeDPrefs.highlightColor);
                graphics.fillRect(n, n2, this.getIconWidth() - 1, this.getIconHeight() - 1);
                ThreeDUtils.drawBorder(ThreeDPrefs.checkBoxBorderType2, graphics, n, n2, this.getIconWidth(), this.getIconHeight());
            } else {
                ThreeDUtils.drawBorder(ThreeDPrefs.checkBoxBorderType1, graphics, n, n2, this.getIconWidth(), this.getIconHeight());
            }
            if (buttonModel.isSelected()) {
                Insets insets = ThreeDUtils.getBorderInsets(ThreeDPrefs.checkBoxBorderType1);
                graphics.setColor(ThreeDPrefs.textColor);
                graphics.fillRect((n += insets.left) + 3, (n2 += insets.top) + 5, 2, 5);
                graphics.drawLine(n + 9, n2 + 3, n + 5, n2 + 7);
                graphics.drawLine(n + 9, n2 + 4, n + 5, n2 + 8);
            }
        }
    }

    static final class ArrowIcon
    implements Icon,
    UIResource {
        private int orientation = 0;
        private int size = 15;
        private Color color = Color.black;

        public ArrowIcon() {
        }

        public ArrowIcon(int n, int n2) {
            this.orientation = n;
            this.size = n2;
        }

        public int getIconHeight() {
            if (this.orientation == 1 || this.orientation == 0) {
                return this.size * 2 - 1;
            }
            return this.size;
        }

        public int getIconWidth() {
            if (this.orientation == 1 || this.orientation == 0) {
                return this.size;
            }
            return this.size * 2 - 1;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Point point = null;
            Point point2 = null;
            Point point3 = null;
            switch (this.orientation) {
                case 1: {
                    point = new Point(0, this.size - 1);
                    point2 = new Point(this.size - 1, 0);
                    point3 = new Point(this.size - 1, this.size * 2 - 2);
                    break;
                }
                case 0: {
                    point = new Point(0, 0);
                    point2 = new Point(0, this.size * 2 - 2);
                    point3 = new Point(this.size - 1, this.size - 1);
                    break;
                }
                case 2: {
                    point = new Point(this.size - 1, 0);
                    point2 = new Point(0, this.size - 1);
                    point3 = new Point(this.size * 2 - 2, this.size - 1);
                    break;
                }
                default: {
                    point = new Point(0, 0);
                    point2 = new Point(this.size * 2 - 2, 0);
                    point3 = new Point(this.size - 1, this.size - 1);
                }
            }
            Polygon polygon = new Polygon();
            polygon.addPoint(point.x, point.y);
            polygon.addPoint(point2.x, point2.y);
            polygon.addPoint(point3.x, point3.y);
            graphics.setColor(this.color);
            graphics.translate(n, n2);
            graphics.fillPolygon(polygon);
            graphics.translate(-n, -n2);
        }

        public void setColor(Color color) {
            this.color = color;
        }

        public void setOrientation(int n) {
            this.orientation = n;
        }

        public void setSize(int n) {
            this.size = n;
        }
    }
}

