/*
 * Decompiled with CFR 0.152.
 */
package swing.addon.plaf.threeD;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JComponent;
import swing.addon.plaf.threeD.ThreeDPrefs;

final class ThreeDUtils {
    public static final int BORDER_TYPES = 12;
    public static final int LINE_LIGHT = 0;
    public static final int LINE_DARK = 1;
    public static final int RAISED_THIN = 2;
    public static final int LOWERED_THIN = 3;
    public static final int RAISED_THICK = 4;
    public static final int LOWERED_THICK = 5;
    public static final int ETCHED_OUT_THIN = 6;
    public static final int ETCHED_IN_THIN = 7;
    public static final int ETCHED_OUT_THICK = 8;
    public static final int ETCHED_IN_THICK = 9;
    public static final int QT_IN = 10;
    public static final int QT_OUT = 11;
    private static final Insets zeroInsets = new Insets(0, 0, 0, 0);
    private static final Insets oneInsets = new Insets(1, 1, 1, 1);
    private static final Insets twoInsets = new Insets(2, 2, 2, 2);
    private static final Insets fourInsets = new Insets(4, 4, 4, 4);

    ThreeDUtils() {
    }

    public static final void drawBorder(int n, Graphics graphics, int n2, int n3, int n4, int n5) {
        graphics.translate(n2, n3);
        switch (n) {
            case 0: {
                graphics.setColor(ThreeDPrefs.lightEdgeColor);
                graphics.drawRect(0, 0, n4 - 1, n5 - 1);
                break;
            }
            case 1: {
                graphics.setColor(ThreeDPrefs.darkEdgeColor);
                graphics.drawRect(0, 0, n4 - 1, n5 - 1);
                break;
            }
            case 2: {
                graphics.setColor(ThreeDPrefs.lightEdgeColor);
                graphics.drawLine(0, 0, 0, n5 - 2);
                graphics.drawLine(0, 0, n4 - 2, 0);
                graphics.setColor(ThreeDPrefs.darkEdgeColor);
                graphics.drawLine(n4 - 1, n5 - 1, n4 - 1, 1);
                graphics.drawLine(n4 - 1, n5 - 1, 1, n5 - 1);
                break;
            }
            case 3: {
                graphics.setColor(ThreeDPrefs.darkEdgeColor);
                graphics.drawLine(0, 0, 0, n5 - 2);
                graphics.drawLine(0, 0, n4 - 2, 0);
                graphics.setColor(ThreeDPrefs.lightEdgeColor);
                graphics.drawLine(n4 - 1, n5 - 1, n4 - 1, 1);
                graphics.drawLine(n4 - 1, n5 - 1, 1, n5 - 1);
                break;
            }
            case 4: {
                graphics.setColor(ThreeDPrefs.lightEdgeColor);
                graphics.drawLine(0, 0, n4 - 1, 0);
                graphics.drawLine(0, 1, n4 - 2, 1);
                graphics.drawLine(0, 0, 0, n5 - 1);
                graphics.drawLine(1, 0, 1, n5 - 2);
                graphics.setColor(ThreeDPrefs.darkEdgeColor);
                graphics.drawLine(n4 - 1, n5 - 1, 1, n5 - 1);
                graphics.drawLine(n4 - 1, n5 - 2, 2, n5 - 2);
                graphics.drawLine(n4 - 1, n5 - 1, n4 - 1, 1);
                graphics.drawLine(n4 - 2, n5 - 1, n4 - 2, 2);
                break;
            }
            case 5: {
                graphics.setColor(ThreeDPrefs.darkEdgeColor);
                graphics.drawLine(0, 0, n4 - 1, 0);
                graphics.drawLine(0, 1, n4 - 2, 1);
                graphics.drawLine(0, 0, 0, n5 - 1);
                graphics.drawLine(1, 0, 1, n5 - 2);
                graphics.setColor(ThreeDPrefs.lightEdgeColor);
                graphics.drawLine(n4 - 1, n5 - 1, 1, n5 - 1);
                graphics.drawLine(n4 - 1, n5 - 2, 2, n5 - 2);
                graphics.drawLine(n4 - 1, n5 - 1, n4 - 1, 1);
                graphics.drawLine(n4 - 2, n5 - 1, n4 - 2, 2);
                break;
            }
            case 6: {
                graphics.setColor(ThreeDPrefs.lightEdgeColor);
                graphics.drawRect(0, 0, n4 - 2, n5 - 2);
                graphics.setColor(ThreeDPrefs.darkEdgeColor);
                graphics.drawRect(1, 1, n4 - 2, n5 - 2);
                break;
            }
            case 7: {
                graphics.setColor(ThreeDPrefs.darkEdgeColor);
                graphics.drawRect(0, 0, n4 - 2, n5 - 2);
                graphics.setColor(ThreeDPrefs.lightEdgeColor);
                graphics.drawRect(1, 1, n4 - 2, n5 - 2);
                break;
            }
            case 8: {
                graphics.setColor(ThreeDPrefs.lightEdgeColor);
                graphics.drawRect(0, 0, n4 - 4, n5 - 4);
                graphics.drawRect(1, 1, n4 - 4, n5 - 4);
                graphics.setColor(ThreeDPrefs.darkEdgeColor);
                graphics.drawRect(2, 2, n4 - 4, n5 - 4);
                graphics.drawRect(3, 3, n4 - 4, n5 - 4);
                break;
            }
            case 9: {
                graphics.setColor(ThreeDPrefs.darkEdgeColor);
                graphics.drawRect(0, 0, n4 - 4, n5 - 4);
                graphics.drawRect(1, 1, n4 - 4, n5 - 4);
                graphics.setColor(ThreeDPrefs.lightEdgeColor);
                graphics.drawRect(2, 2, n4 - 4, n5 - 4);
                graphics.drawRect(3, 3, n4 - 4, n5 - 4);
                break;
            }
            case 11: {
                ThreeDUtils.drawQTBorder(graphics, n4, n5, Color.black, new Color(197, 194, 197), Color.white, new Color(131, 129, 131), new Color(164, 161, 164));
                break;
            }
            case 10: {
                ThreeDUtils.drawQTBorder(graphics, n4, n5, Color.black, new Color(90, 87, 90), new Color(120, 117, 120), Color.white, new Color(197, 194, 197));
            }
        }
        graphics.translate(-n2, -n3);
    }

    public static final void drawBorder(Graphics graphics, int n, int n2, int n3, int n4, Color color, Color color2) {
        graphics.setColor(color);
        graphics.drawLine(n, n2, n, n2 + n4 - 2);
        graphics.drawLine(n, n2, n + n3 - 2, n2);
        graphics.setColor(color2);
        graphics.drawLine(n + n3 - 1, n2 + n4 - 1, n + n3 - 1, n2 + 1);
        graphics.drawLine(n + n3 - 1, n2 + n4 - 1, n + 1, n2 + n4 - 1);
    }

    public static void drawDisabledState(Graphics graphics, JComponent jComponent) {
        Dimension dimension = jComponent.getSize();
        graphics.setColor(ThreeDPrefs.disableColor);
        int n = 0;
        while (n < dimension.height) {
            int n2 = n % 3;
            while (n2 < dimension.width) {
                graphics.drawLine(n2, n, n2, n);
                n2 += 3;
            }
            ++n;
        }
    }

    static final void drawQTBorder(Graphics graphics, int n, int n2, Color color, Color color2, Color color3, Color color4, Color color5) {
        graphics.setColor(color);
        graphics.drawLine(2, 0, n - 3, 0);
        graphics.drawLine(2, n2 - 1, n - 3, n2 - 1);
        graphics.drawLine(0, 2, 0, n2 - 3);
        graphics.drawLine(n - 1, 2, n - 1, n2 - 3);
        graphics.drawLine(1, 1, 1, 1);
        graphics.drawLine(n - 2, 1, n - 2, 1);
        graphics.drawLine(1, n2 - 2, 1, n2 - 2);
        graphics.drawLine(n - 2, n2 - 2, n - 2, n2 - 2);
        graphics.setColor(color2);
        graphics.drawLine(2, 1, n - 3, 1);
        graphics.drawLine(1, 2, 1, n2 - 3);
        graphics.setColor(color3);
        graphics.drawLine(2, 2, 2, n2 - 3);
        graphics.drawLine(2, 2, n - 3, 2);
        graphics.drawLine(3, 3, 3, 3);
        graphics.setColor(color4);
        graphics.drawLine(2, n2 - 2, n - 3, n2 - 2);
        graphics.drawLine(n - 3, n2 - 3, n - 3, n2 - 3);
        graphics.drawLine(n - 2, 2, n - 2, n2 - 3);
        graphics.setColor(color5);
        graphics.drawLine(3, n2 - 3, n - 4, n2 - 3);
        graphics.drawLine(n - 4, n2 - 4, n - 4, n2 - 4);
        graphics.drawLine(n - 3, 3, n - 3, n2 - 4);
    }

    public static Insets getBorderInsets(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return oneInsets;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return twoInsets;
            }
            case 8: 
            case 9: {
                return fourInsets;
            }
            case 10: 
            case 11: {
                return fourInsets;
            }
        }
        System.err.println("ThreeDUtils.getBorderInsets(): internal error");
        return fourInsets;
    }

    public static boolean isLoweredBorderType(int n) {
        return n == 3 || n == 5;
    }
}

