/*
 * Decompiled with CFR 0.152.
 */
package swing.addon.plaf.threeD;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyVetoException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import swing.addon.plaf.threeD.ThreeDIcons;
import swing.addon.plaf.threeD.ThreeDPrefs;
import swing.addon.plaf.threeD.ThreeDUtils;

public class ThreeD_InternalFrameTitlePane
extends JPanel
implements Border,
MouseListener,
ActionListener {
    JInternalFrame frame = null;
    Font font = null;
    JButton closeButton = new JButton(new ThreeDIcons.InternalFrameIcon1());
    JButton iconifyButton = new JButton(new ThreeDIcons.InternalFrameIcon2());
    JButton resizeButton = new JButton(new ThreeDIcons.InternalFrameIcon3());
    JLabel title = new JLabel(""){

        public Dimension getPreferredSize() {
            return new Dimension(Short.MAX_VALUE, Math.max(ThreeD_InternalFrameTitlePane.this.closeButton.getSize().height, super.getPreferredSize().height));
        }
    };

    public ThreeD_InternalFrameTitlePane(JInternalFrame jInternalFrame) {
        this.setLayout(new BoxLayout(this, 0));
        this.setBorder(this);
        this.closeButton.setOpaque(false);
        this.closeButton.setRequestFocusEnabled(false);
        this.closeButton.setMargin(new Insets(1, 1, 1, 1));
        this.closeButton.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.closeButton.addMouseListener(this);
        this.iconifyButton.setOpaque(false);
        this.iconifyButton.setRequestFocusEnabled(false);
        this.iconifyButton.setMargin(new Insets(1, 1, 1, 1));
        this.iconifyButton.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.iconifyButton.addMouseListener(this);
        this.resizeButton.setOpaque(false);
        this.resizeButton.setRequestFocusEnabled(false);
        this.resizeButton.setMargin(new Insets(1, 1, 1, 1));
        this.resizeButton.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.resizeButton.addMouseListener(this);
        this.title.setText(jInternalFrame.getTitle());
        this.title.setFont(ThreeDPrefs.internalFrameTitleFont);
        this.closeButton.addActionListener(this);
        this.iconifyButton.addActionListener(this);
        this.resizeButton.addActionListener(this);
        this.add(this.closeButton);
        this.add(Box.createHorizontalStrut(2));
        this.add(this.title);
        this.add(Box.createHorizontalStrut(2));
        this.add(this.iconifyButton);
        this.add(Box.createHorizontalStrut(2));
        this.add(this.resizeButton);
        this.frame = jInternalFrame;
        this.font = ThreeDPrefs.internalFrameTitleFont;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.closeButton) {
            try {
                this.frame.setClosed(true);
            }
            catch (PropertyVetoException propertyVetoException) {}
        } else if (object == this.iconifyButton) {
            try {
                this.frame.setIcon(!this.frame.isIcon());
            }
            catch (PropertyVetoException propertyVetoException) {}
        } else {
            try {
                this.frame.setMaximum(!this.frame.isMaximum());
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    public Insets getBorderInsets(Component component) {
        return new Insets(1, 1, 1, 1);
    }

    public Dimension getMaximumSize() {
        return new Dimension(Short.MAX_VALUE, this.getPreferredSize().height);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        FontMetrics fontMetrics = ((Component)this).getFontMetrics(this.font);
        int n = 200;
        int n2 = fontMetrics.getAscent() + fontMetrics.getDescent() + 4;
        return new Dimension(n, n2);
    }

    public boolean isBorderOpaque() {
        return true;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        JButton jButton = (JButton)mouseEvent.getSource();
        jButton.setBorder(this);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        JButton jButton = (JButton)mouseEvent.getSource();
        jButton.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void paint(Graphics graphics) {
        this.title.setText(this.frame.getTitle());
        this.remove(this.closeButton);
        this.remove(this.iconifyButton);
        this.remove(this.resizeButton);
        if (this.frame.isIconifiable()) {
            this.add((Component)this.iconifyButton, -1);
        }
        if (this.frame.isResizable()) {
            this.add((Component)this.resizeButton, -1);
        }
        if (this.frame.isClosable()) {
            this.add((Component)this.closeButton, 0);
        }
        super.paint(graphics);
    }

    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        ThreeDUtils.drawBorder(2, graphics, n, n2, n3, n4);
    }

    public void paintComponent(Graphics graphics) {
        Dimension dimension = this.getSize();
        graphics.setColor(this.frame.isSelected() ? ThreeDPrefs.highlightColor : ThreeDPrefs.backgroundColor);
        graphics.fillRect(0, 0, dimension.width, dimension.height);
    }
}

