/*
 * Decompiled with CFR 0.152.
 */
package swing.addon.plaf.threeD;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSliderUI;
import swing.addon.plaf.threeD.ThreeDPrefs;
import swing.addon.plaf.threeD.ThreeDUtils;

public class ThreeD_SliderUI
extends BasicSliderUI {
    public ThreeD_SliderUI(JSlider jSlider) {
        super(jSlider);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new ThreeD_SliderUI((JSlider)jComponent);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        super.paint(graphics, jComponent);
        if (!jComponent.isEnabled()) {
            ThreeDUtils.drawDisabledState(graphics, jComponent);
        }
    }

    public void paintFocus(Graphics graphics) {
        Dimension dimension = this.slider.getSize();
        graphics.setColor(ThreeDPrefs.focusColor);
        graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
    }

    public void paintThumb(Graphics graphics) {
        graphics.setColor(this.slider.getBackground());
        graphics.fillRect(this.thumbRect.x, this.thumbRect.y, this.thumbRect.width, this.thumbRect.height);
        ThreeDUtils.drawBorder(ThreeDPrefs.sliderThumbBorderType, graphics, this.thumbRect.x, this.thumbRect.y, this.thumbRect.width, this.thumbRect.height);
        Insets insets = ThreeDUtils.getBorderInsets(ThreeDPrefs.sliderThumbBorderType);
        graphics.setColor(ThreeDPrefs.sliderThumbColor);
        graphics.fillRect(this.thumbRect.x + insets.left, this.thumbRect.y + insets.top, this.thumbRect.width - insets.left - insets.right, this.thumbRect.height - insets.top - insets.bottom);
    }

    public void paintTrack(Graphics graphics) {
        graphics.setColor(this.slider.getBackground());
        graphics.fillRect(this.trackRect.x, this.trackRect.y, this.trackRect.width - 1, this.trackRect.height - 1);
        Insets insets = ThreeDUtils.getBorderInsets(ThreeDPrefs.sliderTrackBorderType);
        Rectangle rectangle = new Rectangle(this.trackRect.x, this.trackRect.y, this.trackRect.width, this.trackRect.height);
        if (this.slider.getOrientation() == 0) {
            rectangle.height = this.trackRect.height / 3 + this.trackRect.height % 3 + insets.top + insets.bottom;
            rectangle.y += (this.trackRect.height - rectangle.height) / 2;
        } else {
            rectangle.width = this.trackRect.width / 3 + this.trackRect.width % 3 + insets.left + insets.right;
            rectangle.x += (this.trackRect.width - rectangle.width) / 2;
        }
        ThreeDUtils.drawBorder(ThreeDPrefs.sliderTrackBorderType, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.setColor(ThreeDPrefs.sliderTrackColor);
        graphics.fillRect(rectangle.x + insets.left, rectangle.y + insets.top, rectangle.width - insets.left - insets.right, rectangle.height - insets.top - insets.bottom);
    }
}

