/*
 * Decompiled with CFR 0.152.
 */
package swing.addon.text;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Shape;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Segment;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.WrappedPlainView;
import swing.addon.TextEditor;
import swing.addon.text.JavaDocument;
import swing.addon.text.Token;

public class JavaContext
extends StyleContext
implements ViewFactory {
    Style[] tokenStyles;
    transient Color[] tokenColors;
    transient Font[] tokenFonts;

    public JavaContext() {
        Style style = this.getStyle("default");
        this.tokenStyles = new Style[153];
        Token[] tokenArray = Token.all;
        int n = tokenArray.length;
        int n2 = 0;
        while (n2 < n) {
            Token token = tokenArray[n2];
            Style style2 = this.getStyle(token.getCategory());
            if (style2 == null) {
                style2 = this.addStyle(token.getCategory(), style);
            }
            Style style3 = this.addStyle(null, style2);
            style3.addAttribute(Token.TokenAttribute, token);
            this.tokenStyles[token.getScanValue()] = style3;
            ++n2;
        }
    }

    public View create(Element element) {
        return new JavaView(element);
    }

    public Font getFont(int n) {
        if (this.tokenFonts == null) {
            this.tokenFonts = new Font[153];
        }
        if (n < this.tokenFonts.length) {
            Font font = this.tokenFonts[n];
            if (font == null) {
                Style style = this.tokenStyles[n];
                font = this.getFont(style);
            }
            return font;
        }
        return null;
    }

    public Color getForeground(int n) {
        if (this.tokenColors == null) {
            this.tokenColors = new Color[153];
        }
        if (n >= 0 && n < this.tokenColors.length) {
            Color color = this.tokenColors[n];
            if (color == null) {
                Style style = this.tokenStyles[n];
                color = StyleConstants.getForeground(style);
            }
            return color;
        }
        return Color.black;
    }

    public Style getStyleForScanValue(int n) {
        if (n < this.tokenStyles.length) {
            return this.tokenStyles[n];
        }
        return null;
    }

    class JavaView
    extends WrappedPlainView {
        JavaDocument.Scanner lexer;
        boolean lexerValid;

        JavaView(Element element) {
            super(element);
            Document document = this.getDocument();
            if (document instanceof JavaDocument) {
                this.lexer = ((JavaDocument)document).createScanner();
                this.lexerValid = false;
            }
        }

        protected int drawUnselectedText(Graphics graphics, int n, int n2, int n3, int n4) throws BadLocationException {
            Document document = this.getDocument();
            Color color = null;
            int n5 = n3;
            while (n3 < n4) {
                this.updateScanner(n3);
                int n6 = Math.min(this.lexer.getEndOffset(), n4);
                n6 = n6 <= n3 ? n4 : n6;
                Color color2 = JavaContext.this.getForeground(this.lexer.token);
                if (color2 != color && color != null) {
                    graphics.setColor(color);
                    Segment segment = this.getLineBuffer();
                    document.getText(n5, n3 - n5, segment);
                    n = Utilities.drawTabbedText(segment, n, n2, graphics, (TabExpander)this, n5);
                    n5 = n3;
                }
                color = color2;
                n3 = n6;
            }
            graphics.setColor(color);
            Segment segment = this.getLineBuffer();
            document.getText(n5, n4 - n5, segment);
            n = Utilities.drawTabbedText(segment, n, n2, graphics, (TabExpander)this, n5);
            return n;
        }

        public float nextTabStop(float f, int n) {
            int n2 = TextEditor.getTabWidth();
            return ((int)f / n2 + 1) * n2;
        }

        public void paint(Graphics graphics, Shape shape) {
            super.paint(graphics, shape);
            this.lexerValid = false;
        }

        void updateScanner(int n) {
            try {
                if (!this.lexerValid) {
                    JavaDocument javaDocument = (JavaDocument)this.getDocument();
                    this.lexer.setRange(javaDocument.getScannerStart(n), javaDocument.getLength());
                    this.lexerValid = true;
                }
                while (this.lexer.getEndOffset() <= n) {
                    this.lexer.scan();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

