/*
 * Decompiled with CFR 0.152.
 */
package swing.addon.text;

import java.io.IOException;
import java.io.InputStream;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.Segment;
import sun.tools.java.Environment;
import swing.addon.text.UndoableDocument;

public class JavaDocument
extends UndoableDocument {
    static final Object CommentAttribute = new AttributeKey();

    public Scanner createScanner() {
        Scanner scanner;
        try {
            scanner = new Scanner();
        }
        catch (IOException iOException) {
            scanner = null;
        }
        return scanner;
    }

    public int getScannerStart(int n) {
        Element element = this.getDefaultRootElement();
        int n2 = element.getElementIndex(n);
        Element element2 = element.getElement(n2);
        AttributeSet attributeSet = element2.getAttributes();
        while (attributeSet.isDefined(CommentAttribute) && n2 > 0) {
            element2 = element.getElement(--n2);
            attributeSet = element2.getAttributes();
        }
        return element2.getStartOffset();
    }

    protected void insertUpdate(AbstractDocument.DefaultDocumentEvent defaultDocumentEvent, AttributeSet attributeSet) {
        super.insertUpdate(defaultDocumentEvent, attributeSet);
        Element element = this.getDefaultRootElement();
        DocumentEvent.ElementChange elementChange = defaultDocumentEvent.getChange(element);
        if (elementChange != null) {
            Element[] elementArray = elementChange.getChildrenAdded();
            boolean bl = false;
            int n = 0;
            while (n < elementArray.length) {
                String string;
                Element element2 = elementArray[n];
                int n2 = element2.getStartOffset();
                int n3 = element2.getEndOffset();
                try {
                    string = this.getText(n2, n3 - n2);
                }
                catch (BadLocationException badLocationException) {
                    string = null;
                }
                if (bl) {
                    MutableAttributeSet mutableAttributeSet = (MutableAttributeSet)element2.getAttributes();
                    mutableAttributeSet.addAttribute(CommentAttribute, CommentAttribute);
                    int n4 = string.indexOf("*/");
                    if (n4 >= 0) {
                        bl = false;
                    }
                } else {
                    int n5 = string.indexOf("/*");
                    if (n5 >= 0 && (n5 = string.indexOf("*/", n5)) < 0) {
                        bl = true;
                    }
                }
                ++n;
            }
        }
    }

    protected void removeUpdate(AbstractDocument.DefaultDocumentEvent defaultDocumentEvent) {
        super.removeUpdate(defaultDocumentEvent);
    }

    public class Scanner
    extends sun.tools.java.Scanner {
        DocumentInputStream dis;
        int p0;

        Scanner() throws IOException {
            super((Environment)new LocalEnvironment());
            this.dis = new DocumentInputStream(0, JavaDocument.this.getLength());
            this.scanComments = true;
        }

        public final int getEndOffset() {
            int n = (int)(this.getEndPos() & 0xFFFFFFFFL);
            return this.p0 + n;
        }

        public final int getStartOffset() {
            int n = (int)(this.pos & 0xFFFFFFFFL);
            return this.p0 + n;
        }

        public void setRange(int n, int n2) throws IOException {
            this.useInputStream(new DocumentInputStream(n, n2));
            this.p0 = n;
        }
    }

    static class LocalEnvironment
    extends Environment {
        LocalEnvironment() {
        }

        public void error(Object object, int n, String string, Object object2, Object object3, Object object4) {
        }
    }

    class DocumentInputStream
    extends InputStream {
        Segment segment = new Segment();
        int p0;
        int p1;
        int pos;
        int index;

        public DocumentInputStream(int n, int n2) {
            this.p0 = n;
            this.p1 = Math.min(JavaDocument.this.getLength(), n2);
            this.pos = n;
            try {
                this.loadSegment();
            }
            catch (IOException iOException) {
                throw new Error("unexpected: " + iOException);
            }
        }

        void loadSegment() throws IOException {
            try {
                int n = Math.min(1024, this.p1 - this.pos);
                JavaDocument.this.getText(this.pos, n, this.segment);
                this.pos += n;
                this.index = this.segment.offset;
            }
            catch (BadLocationException badLocationException) {
                throw new IOException("Bad location");
            }
        }

        public int read() throws IOException {
            if (this.index >= this.segment.offset + this.segment.count) {
                if (this.pos >= this.p1) {
                    return -1;
                }
                this.loadSegment();
            }
            return this.segment.array[this.index++];
        }
    }

    static class AttributeKey {
        private AttributeKey() {
        }

        public String toString() {
            return "comment";
        }
    }
}

