/*
 * Decompiled with CFR 0.152.
 */
package swing.addon.text;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.GapContent;
import javax.swing.text.PlainDocument;
import javax.swing.undo.UndoManager;
import jreqtools.JReqTools;
import swing.addon.GUISystem;

public class UndoableDocument
extends PlainDocument {
    private UndoManager undo = new UndoManager();
    private UndoAction undoAction = new UndoAction();
    private RedoAction redoAction = new RedoAction();
    private UndoableEditListener listener = new UndoHandler();

    public UndoableDocument() {
        super(new GapContent(1024));
        this.addUndoableEditListener(this.listener);
    }

    public boolean canRedo() {
        return this.undo.canRedo();
    }

    public boolean canUndo() {
        return this.undo.canUndo();
    }

    public String getText() {
        try {
            return this.getText(0, this.getLength());
        }
        catch (BadLocationException badLocationException) {
            GUISystem.err.println(this.getClass().getName() + ".getText(): " + badLocationException);
            return "GET TEXT FAILED -> SORRY.";
        }
    }

    public void redo() {
        this.undo.redo();
        this.redoAction.update();
        this.undoAction.update();
    }

    public void setText(String string) {
        this.removeUndoableEditListener(this.listener);
        try {
            this.remove(0, this.getLength());
            ((AbstractDocument)this).insertString(0, string, null);
        }
        catch (BadLocationException badLocationException) {
            GUISystem.err.println(this.getClass().getName() + ".setText(): " + badLocationException);
        }
        this.addUndoableEditListener(this.listener);
    }

    public void undo() {
        this.undo.undo();
        this.undoAction.update();
        this.redoAction.update();
    }

    class UndoHandler
    implements UndoableEditListener {
        UndoHandler() {
        }

        public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
            UndoableDocument.this.undo.addEdit(undoableEditEvent.getEdit());
            UndoableDocument.this.undoAction.update();
            UndoableDocument.this.redoAction.update();
        }
    }

    class UndoAction
    extends AbstractAction {
        public UndoAction() {
            super("undo");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                UndoableDocument.this.undo.undo();
            }
            catch (Throwable throwable) {
                JReqTools.showException(throwable);
            }
            this.update();
            UndoableDocument.this.redoAction.update();
        }

        protected void update() {
            this.setEnabled(UndoableDocument.this.undo.canUndo());
        }
    }

    class RedoAction
    extends AbstractAction {
        public RedoAction() {
            super("redo");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                UndoableDocument.this.undo.redo();
            }
            catch (Throwable throwable) {
                JReqTools.showException(throwable);
            }
            this.update();
            UndoableDocument.this.undoAction.update();
        }

        protected void update() {
            this.setEnabled(UndoableDocument.this.undo.canRedo());
        }
    }
}

