/*
 * Decompiled with CFR 0.152.
 */
package swing.addon.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public class FileAccess {
    private static final boolean DEBUG = false;
    public static final int READ = 1;
    public static final int WRITE = 2;
    FileReader reader;
    FileWriter writer;
    BufferedReader in;
    BufferedWriter out;
    String name;
    boolean isopen;
    int mode;
    IOException exception;

    public FileAccess(String string) {
        this(string, 1);
    }

    public FileAccess(File file) {
        this(file, 1);
    }

    public FileAccess(File file, int n) {
        this.mode = n;
        this.name = file.getAbsolutePath();
        this.isopen = false;
        this.open();
    }

    public FileAccess(String string, int n) {
        this.mode = n;
        this.name = string;
        this.isopen = false;
        this.open();
    }

    public void close() {
        try {
            if (this.mode == 1 && this.isopen) {
                this.in.close();
                this.reader.close();
            } else if (this.mode == 2 && this.isopen) {
                this.out.close();
                this.writer.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.isopen = false;
        this.in = null;
        this.out = null;
        this.reader = null;
        this.writer = null;
    }

    public void finalize() throws InterruptedException {
        this.close();
    }

    public synchronized void newLine() throws IOException {
        if (!this.isopen) {
            throw this.exception;
        }
        if (this.mode == 1) {
            throw new IOException("File is opened for reading only.");
        }
        this.out.newLine();
    }

    private void open() {
        try {
            if (this.mode == 1) {
                this.reader = new FileReader(this.name);
                this.in = new BufferedReader(this.reader);
                this.isopen = true;
            } else {
                this.writer = new FileWriter(this.name);
                this.out = new BufferedWriter(this.writer);
                this.isopen = true;
            }
        }
        catch (IOException iOException) {
            this.exception = iOException;
        }
    }

    public String readLine() throws IOException {
        if (!this.isopen) {
            throw this.exception;
        }
        if (this.mode == 2) {
            throw new IOException("File is opened for writing only.");
        }
        return this.in.readLine();
    }

    public String readLine(int n) throws IOException {
        this.close();
        this.open();
        if (!this.isopen) {
            throw this.exception;
        }
        if (this.mode == 2) {
            throw new IOException("File is opened for writing only.");
        }
        String string = null;
        int n2 = 0;
        while (n2 < n) {
            string = this.in.readLine();
            ++n2;
        }
        return string;
    }

    public void write(long l) throws IOException {
        String string = "" + l;
        this.write(string);
    }

    public synchronized void write(String string) throws IOException {
        if (!this.isopen) {
            throw this.exception;
        }
        if (this.mode == 1) {
            throw new IOException("File is opened for reading only.");
        }
        this.out.write(string);
    }

    public void write(int n) throws IOException {
        String string = "" + n;
        this.write(string);
    }

    public void write(char c) throws IOException {
        String string = "" + c;
        this.write(string);
    }

    public void write(float f) throws IOException {
        String string = "" + f;
        this.write(string);
    }

    public void write(double d) throws IOException {
        String string = "" + d;
        this.write(string);
    }

    public void write(boolean bl) throws IOException {
        String string = "" + bl;
        this.write(string);
    }

    public void writeLine(String string) throws IOException {
        this.write(string);
        this.newLine();
    }

    public void writeLine(char c) throws IOException {
        String string = "" + c;
        this.write(string);
        this.newLine();
    }

    public void writeLine(int n) throws IOException {
        String string = "" + n;
        this.write(string);
        this.newLine();
    }

    public void writeLine(long l) throws IOException {
        String string = "" + l;
        this.write(string);
        this.newLine();
    }

    public void writeLine(float f) throws IOException {
        String string = "" + f;
        this.write(string);
        this.newLine();
    }

    public void writeLine(double d) throws IOException {
        String string = "" + d;
        this.write(string);
        this.newLine();
    }

    public void writeLine(boolean bl) throws IOException {
        String string = "" + bl;
        this.write(string);
        this.newLine();
    }
}

