/*
 * Decompiled with CFR 0.152.
 */
package swing.addon.util;

import java.io.PrintWriter;

public class ThreadLister {
    private static final boolean DEBUG = false;

    public static void listAllThreads(PrintWriter printWriter) {
        ThreadGroup threadGroup;
        ThreadGroup threadGroup2 = threadGroup = Thread.currentThread().getThreadGroup();
        ThreadGroup threadGroup3 = threadGroup2.getParent();
        while (threadGroup3 != null) {
            threadGroup2 = threadGroup3;
            threadGroup3 = threadGroup3.getParent();
        }
        ThreadLister.printGroupInfo(printWriter, threadGroup2, "");
    }

    private static void printGroupInfo(PrintWriter printWriter, ThreadGroup threadGroup, String string) {
        if (threadGroup == null) {
            return;
        }
        int n = threadGroup.activeCount();
        int n2 = threadGroup.activeGroupCount();
        Thread[] threadArray = new Thread[n];
        ThreadGroup[] threadGroupArray = new ThreadGroup[n2];
        threadGroup.enumerate(threadArray, false);
        threadGroup.enumerate(threadGroupArray, false);
        printWriter.println(string + "Thread Group: " + threadGroup.getName() + "  Max Priority: " + threadGroup.getMaxPriority() + (threadGroup.isDaemon() ? " Daemon" : ""));
        int n3 = 0;
        while (n3 < n) {
            ThreadLister.printThreadInfo(printWriter, threadArray[n3], string + "    ");
            ++n3;
        }
        int n4 = 0;
        while (n4 < n2) {
            ThreadLister.printGroupInfo(printWriter, threadGroupArray[n4], string + "    ");
            ++n4;
        }
    }

    private static void printThreadInfo(PrintWriter printWriter, Thread thread, String string) {
        if (thread == null) {
            return;
        }
        printWriter.println(string + "Thread: " + thread.getName() + "  Priority: " + thread.getPriority() + (thread.isDaemon() ? " Daemon" : "") + (thread.isAlive() ? "" : " Not Alive"));
    }
}

