/*
 * Decompiled with CFR 0.152.
 */
package jedi.plugins.appletstarter;

import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import jedi.Jedi;
import jedi.JediPlugin;
import jedi.ds.Class;
import jedi.ds.Package;
import jedi.ds.Project;
import jreqtools.JReqTools;
import swing.addon.FileString;
import swing.addon.Frame;
import swing.addon.GUISystem;
import swing.addon.OkCancelButtons;
import swing.addon.Prefs;
import swing.addon.Separator;
import swing.addon.Strut;
import swing.addon.TextArea;
import swing.addon.YFramePanel;

public class AppletStarter
implements JediPlugin {
    static final ResourceBundle resources = ResourceBundle.getBundle("jedi.plugins.appletstarter.resources.appletstarter");
    protected static final String APPLETVIEWER = "Appletviewer";
    protected static final String INSTALLATION_PATH = "InstallationPath";
    protected static final String DEFAULT_HTML_FILE = "DefaultHTMLFile";
    private Hashtable prefs = new Hashtable();
    private PrefsFrame prefsFrame = null;
    private ExecuteFrame executeFrame = null;
    private static File saveDirectory = null;

    static String GRS(String string) {
        try {
            return resources.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            System.err.println(missingResourceException.getLocalizedMessage() + ": '" + string + "'");
            return "MISSING RESOURCE: " + string;
        }
    }

    static String GRS(String string, String string2) {
        String string3 = AppletStarter.GRS(string);
        try {
            string3 = MessageFormat.format(string3, string2);
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
        return string3;
    }

    public void editPrefs() {
        if (this.prefsFrame == null) {
            this.prefsFrame = new PrefsFrame();
        }
        this.prefsFrame.setVisible(true);
    }

    public void execute() {
        Class clazz;
        if (this.executeFrame == null) {
            this.executeFrame = new ExecuteFrame();
        }
        if ((clazz = this.findSubClassOfAppletIn(Jedi.getEditor().getProject())) == null) {
            JReqTools.showError((JFrame)Jedi.getEditor(), (String)AppletStarter.GRS("Error.01"));
            return;
        }
        this.executeFrame.setClass(clazz);
        this.executeFrame.setVisible(true);
    }

    private Class findSubClassOfAppletIn(Package package_) {
        Vector vector = package_.getClasses();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Class clazz = (Class)enumeration.nextElement();
            String string = clazz.getExtends();
            if (string.equals("Applet")) {
                return clazz;
            }
            if (!string.equals("java.applet.Applet")) continue;
            return clazz;
        }
        return null;
    }

    private Class findSubClassOfAppletIn(Project project) {
        Package[] packageArray = project.getPackages();
        int n = 0;
        while (n < packageArray.length) {
            Class clazz = this.findSubClassOfAppletIn(packageArray[n]);
            if (clazz != null) {
                return clazz;
            }
            ++n;
        }
        return null;
    }

    public String getAppletviewer() {
        String string = (String)this.prefs.get(APPLETVIEWER);
        if (string == null) {
            string = "";
        }
        return string;
    }

    public String getAuthor() {
        return "Markus Hillenbrand (hillenbr@informatik.uni-kl.de)";
    }

    public JComponent getComponent() {
        return null;
    }

    public String getDescription() {
        return AppletStarter.GRS("AppletStarter.Description");
    }

    public String getDocumentation() {
        return null;
    }

    public String getHTMLTagsFor(String string) {
        String string2 = (String)this.prefs.get(string);
        if (string2 == null) {
            string2 = "";
        }
        return string2;
    }

    public Icon getIcon() {
        return Prefs.getIcon((String)"select-all");
    }

    public Object getPrefs() {
        return this.prefs;
    }

    public int getRevision() {
        return 7;
    }

    public int getVersion() {
        return 2;
    }

    public boolean hasPreferencesFrame() {
        return true;
    }

    public static void main(String[] stringArray) {
        AppletStarter appletStarter = new AppletStarter();
        System.out.println(AppletStarter.GRS("AppletStarter.Main"));
        System.exit(0);
    }

    public void runApplet(String string) {
        try {
            String string2 = this.getHTMLTagsFor(string);
            String string3 = saveDirectory + File.separator + "AppletStarter.html";
            String string4 = "-J-classpath " + Project.compileDir.getAbsolutePath() + File.pathSeparatorChar + Jedi.getCompiler().getClasspath();
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string3));
            bufferedWriter.write(string2);
            bufferedWriter.close();
            final String[] stringArray = new String[]{this.getAppletviewer(), string4, string3};
            new Thread(){

                public void run() {
                    try {
                        Process process = Runtime.getRuntime().exec(stringArray);
                        System.out.println(AppletStarter.GRS("AppletStarter.Output"));
                        new OutputFetcher(new BufferedReader(new InputStreamReader(process.getInputStream()))).start();
                        new OutputFetcher(new BufferedReader(new InputStreamReader(process.getErrorStream()))).start();
                        process.waitFor();
                        if (process.exitValue() != 0) {
                            JReqTools.showError((JFrame)Jedi.getEditor(), (String)AppletStarter.GRS("AppletStarter.ExitValue", "" + process.exitValue()));
                        }
                    }
                    catch (Exception exception) {
                        JReqTools.showException((JFrame)Jedi.getEditor(), (Throwable)exception);
                    }
                }
            }.start();
        }
        catch (IOException iOException) {
            JReqTools.showException((JFrame)Jedi.getEditor(), (Throwable)iOException);
            return;
        }
    }

    public void setAppletviewer(String string) {
        if (string == null) {
            string = "";
        }
        this.prefs.put(APPLETVIEWER, string);
    }

    public void setHTMLTagsFor(String string, String string2) {
        if (string == null) {
            return;
        }
        if (string2 == null) {
            return;
        }
        this.prefs.put(string, string2);
    }

    public void setInstallationPath(String string) {
        this.prefs.put(INSTALLATION_PATH, string);
    }

    public void setPrefs(Object object) {
        this.prefs = (Hashtable)object;
    }

    static {
        saveDirectory = new File(Jedi.getHomeDirectory(), "tmp");
        saveDirectory.mkdirs();
    }

    public class PrefsFrame
    extends Frame
    implements ActionListener {
        FileString appletviewer;
        OkCancelButtons buttons;

        public PrefsFrame() {
            super(AppletStarter.GRS("PrefsFrame.Title"));
            this.appletviewer = new FileString(AppletStarter.this.getAppletviewer());
            this.buttons = new OkCancelButtons();
            this.buttons.addActionListener((ActionListener)this);
            YFramePanel yFramePanel = new YFramePanel();
            yFramePanel.add((Component)new Separator(AppletStarter.GRS("PrefsFrame.Select")));
            yFramePanel.add((Component)this.appletviewer);
            yFramePanel.add(Box.createVerticalGlue());
            yFramePanel.add((Component)this.buttons);
            ((JFrame)((Object)this)).setContentPane((Container)yFramePanel);
            ((Window)((Object)this)).pack();
            Prefs.add((String)"Plugin.AppletStarter.PrefsFrame", (Object)this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            switch (this.buttons.get()) {
                case 0: {
                    AppletStarter.this.setAppletviewer(this.appletviewer.getFile().toString());
                    this.setVisible(false);
                    break;
                }
                case 1: {
                    this.appletviewer.setFile(AppletStarter.this.getAppletviewer());
                    this.setVisible(false);
                    break;
                }
                default: {
                    GUISystem.err.println("AppletStarter.PrefsFrame.actionPerformed(): internal error");
                    this.setVisible(false);
                }
            }
        }
    }

    public final class OutputFetcher
    extends Thread {
        BufferedReader stream;

        public OutputFetcher(BufferedReader bufferedReader) {
            super("AppletStarter Output Fetcher");
            this.setPriority(4);
            this.stream = bufferedReader;
        }

        public void run() {
            try {
                int n;
                while ((n = this.stream.read()) != -1) {
                    System.out.print((char)n);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public class ExecuteFrame
    extends Frame
    implements ActionListener {
        OkCancelButtons buttons = new OkCancelButtons(AppletStarter.GRS("ExecuteFrame.Start"), AppletStarter.GRS("ExecuteFrame.Cancel"));
        Separator separator = new Separator("");
        TextArea htmlTags = new TextArea();
        Class toRun = null;

        public ExecuteFrame() {
            super(AppletStarter.GRS("ExecuteFrame.Title"));
            this.buttons.addActionListener((ActionListener)this);
            YFramePanel yFramePanel = new YFramePanel();
            yFramePanel.add((Component)this.separator);
            yFramePanel.add((Component)this.htmlTags);
            yFramePanel.add((Component)new Strut());
            yFramePanel.add((Component)this.buttons);
            ((JFrame)((Object)this)).setContentPane((Container)yFramePanel);
            ((Window)((Object)this)).pack();
            Prefs.add((String)"Plugin.AppletStarter.ExecuteFrame", (Object)this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            switch (this.buttons.get()) {
                case 0: {
                    AppletStarter.this.setHTMLTagsFor(this.toRun.getFullName(), this.htmlTags.getText());
                    AppletStarter.this.runApplet(this.toRun.getFullName());
                    this.setVisible(false);
                    break;
                }
                case 1: {
                    this.setVisible(false);
                    break;
                }
                default: {
                    GUISystem.err.println("AppletStarter.PrefsFrame.actionPerformed(): internal error");
                    this.setVisible(false);
                }
            }
        }

        public void setClass(Class clazz) {
            if (clazz == null) {
                GUISystem.err.println(this.getClass().getName() + ".setClass(): argument was null");
                return;
            }
            this.toRun = clazz;
            String string = clazz.getFullName();
            this.separator.set(string);
            String string2 = AppletStarter.this.getHTMLTagsFor(string);
            if (string2.equals("")) {
                string2 = "<APPLET CODE=\"" + string + ".class\"\n\tWIDTH=500\n\tHEIGHT=400>\n</APPLET>";
            }
            this.htmlTags.setText(string2);
        }
    }
}

