/*
 * Decompiled with CFR 0.152.
 */
package jedi.plugins.incrementalsearch;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import jedi.Jedi;
import jedi.JediPlugin;
import jreqtools.JReqTools;
import swing.addon.JavaEditor;

public class IncrementalSearch
implements JediPlugin,
Icon,
DocumentListener,
ActionListener,
FocusListener {
    static final ResourceBundle resources = ResourceBundle.getBundle("jedi.plugins.incrementalsearch.resources.incrementalsearch");
    JTextField searchText;
    JPanel fullPanel = new JPanel();
    int startPos;

    public IncrementalSearch() {
        this.fullPanel.setLayout(new BorderLayout());
        this.searchText = new JTextField(10);
        this.searchText.getDocument().addDocumentListener(this);
        this.searchText.addActionListener(this);
        this.searchText.addFocusListener(this);
        this.searchText.setNextFocusableComponent(Jedi.getEditor().getEditor().getTextComponent());
        this.startPos = -1;
        ImageIcon imageIcon = this.getIcon("isearch.gif");
        JLabel jLabel = new JLabel(imageIcon);
        this.fullPanel.add("West", jLabel);
        this.fullPanel.add("Center", this.searchText);
    }

    static String GRS(String string) {
        try {
            return resources.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            System.err.println(missingResourceException.getLocalizedMessage() + ": '" + string + "'");
            return "MISSING RESOURCE: " + string;
        }
    }

    static String GRS(String string, String string2) {
        String string3 = IncrementalSearch.GRS(string);
        try {
            string3 = MessageFormat.format(string3, string2);
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
        return string3;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JavaEditor javaEditor = Jedi.getEditor().getEditor();
        this.startPos = javaEditor.getCaretPosition();
        this.findKey(true);
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.findKey(false);
    }

    public void editPrefs() {
    }

    public void execute() {
        this.searchText.requestFocus();
    }

    protected void findKey(boolean bl) {
        JavaEditor javaEditor = Jedi.getEditor().getEditor();
        Document document = javaEditor.getDocument();
        try {
            String string = document.getText(this.startPos, document.getLength() - this.startPos);
            int n = string.indexOf(this.searchText.getText());
            if (n == -1 && bl) {
                this.fullPanel.getToolkit().beep();
            } else {
                javaEditor.select(this.startPos + n, this.startPos + n + this.searchText.getText().length());
            }
        }
        catch (BadLocationException badLocationException) {
            JReqTools.showError((String)IncrementalSearch.GRS("Error.01"));
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        JavaEditor javaEditor = Jedi.getEditor().getEditor();
        this.startPos = javaEditor.getCaretPosition();
    }

    public void focusLost(FocusEvent focusEvent) {
        JavaEditor javaEditor = Jedi.getEditor().getEditor();
        this.startPos = javaEditor.getCaretPosition();
        this.searchText.setText("");
    }

    public String getAuthor() {
        return "Andreas Raquet <raquet@informatik.uni-kl.de>";
    }

    public JComponent getComponent() {
        return this.fullPanel;
    }

    public String getDescription() {
        return IncrementalSearch.GRS("Description");
    }

    public String getDocumentation() {
        return null;
    }

    public Icon getIcon() {
        return null;
    }

    ImageIcon getIcon(String string) {
        try {
            int n;
            InputStream inputStream = this.getClass().getResourceAsStream("icons/" + string);
            if (inputStream == null) {
                System.err.println("[ERROR in method " + this.getClass().getName() + ".getIcon(): Can't load icon '" + string + "']");
                return null;
            }
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
            byte[] byArray = new byte[1024];
            while ((n = bufferedInputStream.read(byArray)) > 0) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            bufferedInputStream.close();
            byteArrayOutputStream.flush();
            byArray = byteArrayOutputStream.toByteArray();
            return new ImageIcon(byArray);
        }
        catch (Exception exception) {
            System.err.println(exception);
            return null;
        }
    }

    public int getIconHeight() {
        return 12;
    }

    public int getIconWidth() {
        return 120;
    }

    public Object getPrefs() {
        return null;
    }

    public int getRevision() {
        return 4;
    }

    public int getVersion() {
        return 1;
    }

    public boolean hasPreferencesFrame() {
        return false;
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.findKey(true);
    }

    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.findKey(false);
    }

    public void setInstallationPath(String string) {
    }

    public void setPrefs(Object object) {
    }
}

